<?php

namespace GiveRecurring\PaymentGatewayModules\Modules\GoCardless\Actions;

use Exception;
use Give\Framework\PaymentGateways\Exceptions\PaymentGatewayException;
use Give\Subscriptions\Models\Subscription;
use GiveRecurring\PaymentGatewayModules\Modules\GoCardless\DataTransferObjects\GoCardlessSubscription;

/**
 * @since 2.14.0
 */
class GetGoCardlessSubscriptionDetails
{
    /**
     * @since 2.14.0
     *
     * @throws PaymentGatewayException
     */
    public function __invoke(Subscription $subscription): GoCardlessSubscription
    {
        if (empty($subscription->gatewaySubscriptionId)) {
            throw new PaymentGatewayException(
                sprintf(
                    __('Unable to get subscription details for #%s. Subscription does not have gatewaySubscriptionId.', 'give-gocardless'),
                    $subscription->id
                )
            );
        }

        $response = \Give_GoCardless_API::get_subscription($subscription->gatewaySubscriptionId);

        if (is_wp_error($response) || isset($response['error'])) {
            throw new PaymentGatewayException(sprintf(
                __('Error getting subscription details for #%s: %s - %s', 'give-gocardless'),
                $subscription->gatewaySubscriptionId,
                isset($response['error']['code']) ? $response['error']['code'] : $response->get_error_code(),
                isset($response['error']['message']) ? $response['error']['message'] : $response->get_error_message()
            ));
        }

        if (empty($response['subscriptions'])) {
            throw new PaymentGatewayException(
                sprintf(
                    __('Unexpected response from GoCardless for subscription #%s', 'give-gocardless'),
                    $subscription->gatewaySubscriptionId
                )
            );
        }

        return GoCardlessSubscription::fromArray($response['subscriptions']);
    }
}
