<?php

namespace GiveRecurring\PaymentGatewayModules\Modules\Braintree\Admin;

/**
 * @since 2.8.0
 */
class Notices
{
    /**
     * @since 2.8.0
     */
    public function WebhookUrlWarning()
    {
        $notice = [
            'id' => 'give-braintree-webhook-url-warning',
            'type' => 'warning',
            'description' => sprintf(
                __('For Braintree subscriptions statuses to update properly, you must copy the Webhook URL from the <a href="%s" >settings page</a> and paste it into a new webhook in your Braintree Control Panel. <a href="%s" target="_blank">Learn how to create webhooks in the Braintree Control Panel &raquo;</a>',
                    'give-braintree'),
                admin_url('/edit.php?post_type=give_forms&page=give-settings&tab=gateways&section=braintree'),
                'https://developer.paypal.com/braintree/articles/control-panel/webhooks#creating-webhooks'
            ),
            'dismissible' => true,
            'dismissible_type' => 'user',
            'dismiss_interval' => 'permanent',
        ];

        Give()->notices->register_notice($notice);
    }
}
