<?php

namespace GiveRecurring\PaymentGatewayModules\Modules\Blink\DataTransferObjects;

use Give\Framework\PaymentGateways\Exceptions\PaymentGatewayException;

/**
 * @since 2.11.0
 */
class BlinkSubscriptionWebhookRequestDTO
{
    /**
     * @var string
     */
    public $hookType;

    /**
     * @var string
     */
    public $message;

    /**
     * @var string
     */
    public $scheduleId;

    /**
     * @var string
     */
    public $scheduleReference;

    /**
     * @var string
     */
    public $reference;

    /**
     * @var string
     */
    public $recurringId;

    /**
     * @var string
     */
    public $amount;

    /**
     * @var string
     */
    public $status;

    /**
     * @since 2.11.0
     *
     * @throws PaymentGatewayException
     */
    public static function fromArray(array $data): BlinkSubscriptionWebhookRequestDTO
    {
        $self = new self();

        $self->hookType = $data['hook_type'] ?? '';
        $self->message = $data['message'] ?? '';
        $self->scheduleId = $data['schedule_id'] ?? '';
        $self->scheduleReference = $data['schedule_reference'] ?? '';
        $self->reference = $data['reference'] ?? '';
        $self->recurringId = $data['recurring_id'] ?? '';
        $self->amount = $data['amount'] ?? '';
        $self->status = $data['status'] ?? '';

        if (empty($self->hookType)) {
            throw new PaymentGatewayException(__('[Blink] Missing hook type.', 'give-blink'));
        }

        if (empty($self->scheduleId)) {
            throw new PaymentGatewayException(__('[Blink] Missing subscription id.', 'give-blink'));
        }

        return $self;
    }
}
