<?php

namespace GiveRecurring\LegacySubscription;

use Give\Framework\Exceptions\Primitives\Exception;
use Give\Helpers\Call;
use Give\Helpers\Hooks;
use Give\Log\Log;
use Give\Subscriptions\Models\Subscription;
use Give\Subscriptions\ValueObjects\SubscriptionStatus;
use GiveRecurring\LegacySubscription\LegacyListeners\DispatchGiveSubscriptionStatus;
use ReflectionException;

/**
 * @since 2.0.0
 */
class ServiceProvider implements \Give\ServiceProviders\ServiceProvider
{

    /**
     * @since 2.0.0
     * @inerhitDoc
     */
    public function register()
    {
    }

    /**
     * @since 2.10.0 Add legacy listeners
     * @since 2.0.0
     * @inerhitDoc
     */
    public function boot()
    {
        add_action('init', static function () {
            try {
                (new LegacySubscriptionAdapter())();
            } catch (Exception|ReflectionException $e) {
                Log::error('LegacySubscriptionAdapter error', ['message' => $e->getMessage()]);
            }
        }, 15);

        $this->addLegacyListeners();
    }

    /**
     * @since 2.10.0
     */
    private function addLegacyListeners()
    {
        add_action('givewp_subscription_updated', function (Subscription $subscription) {
            if ($subscription->isDirty('status')) {
                /** @var SubscriptionStatus $oldStatus */
                $oldStatus = $subscription->getOriginal('status');

                give(DispatchGiveSubscriptionStatus::class)($subscription->id,
                    $subscription->status->getValue(), $oldStatus->getValue());
            }
        });

        Hooks::addAction('give_recurring_update_subscription_status', DispatchGiveSubscriptionStatus::class,
            '__invoke', 10, 3);
    }
}
