<?php
namespace GiveFormFieldManager\Tracking;

use Give\Helpers\Form\Utils;
use Give\ServiceProviders\ServiceProvider as GiveWPServiceProvider;
use GiveFormFieldManager\FormFields\ValueObjects\MetaKey;

/**
 * Class TrackingServiceProvider
 * @package GiveFormFieldManager\Tracking
 *
 * @since 2.0.0
 */
class ServiceProvider implements GiveWPServiceProvider {
	/**
	 * @inheritdoc
	 */
	public function register() {
	}

	/**
	 * @inheritdoc
     *
     * @since 3.0.0 Add support for v3 forms
     */
	public function boot() {

		add_filter(
			'give_telemetry_form_uses_addon_form_field_manager',
			static function( $result, $formId ) {
                if (method_exists(Utils::class, 'isV3Form') && Utils::isV3Form($formId)) {
                    $formBuilderFields = give()->form_meta->get_meta($formId, 'formBuilderFields', true);

                    return ! empty($formBuilderFields) && strpos($formBuilderFields,
                            'givewp-form-field-manager') !== false;
                } else {
                    return ! empty(give()->form_meta->get_meta($formId, MetaKey::fields()->getValue(), true));
                }
			},
			10,
			2
		);
	}
}
