<?php

namespace GiveFormFieldManager\FormExtension;

use Give\Helpers\Hooks;
use Give\ServiceProviders\ServiceProvider as ServiceProviderContract;
use GiveFormFieldManager\FormExtension\DonationForm\Actions\ConvertBlocksInForm;
use GiveFormFieldManager\FormExtension\DonationForm\Actions\MapConditionalLogicToFields;
use GiveFormFieldManager\FormExtension\Hooks\FormBuilderScriptsEnqueue;

class ServiceProvider implements ServiceProviderContract
{
    public function register()
    {
    }

    public function boot()
    {
        Hooks::addAction('givewp_form_builder_enqueue_scripts', FormBuilderScriptsEnqueue::class);
        Hooks::addFilter('givewp_donation_form_block_render', ConvertBlocksInForm::class, '__invoke', 10, 4);
        Hooks::addAction('givewp_donation_form_schema', MapConditionalLogicToFields::class, '__invoke', 10, 3);
    }
}
