<?php

namespace GiveFormFieldManager\FormExtension\Hooks;

use Give\Framework\EnqueueScript;

class DonationFormScriptsEnqueue
{
    /**
     * @since 3.0.0
     */
    public function __invoke()
    {
        $scriptAsset = require GIVE_FFM_PLUGIN_DIR . '/build/ffmDonationFormExtension.asset.php';

        (new EnqueueScript(
            'givewp-form-extension-form-field-manager',
            'build/ffmDonationFormExtension.js',
            GIVE_FFM_PLUGIN_DIR,
            GIVE_FFM_PLUGIN_URL,
            'give-form-field-manager'
        ))->enqueue();

        wp_enqueue_style(
            'givewp-form-extension-form-field-manager',
            GIVE_FFM_PLUGIN_URL . 'build/ffmDonationFormExtension.css',
            [],
            $scriptAsset['version']
        );
    }
}
