import {BlockConfiguration} from '@wordpress/blocks';
import registerConditionalLogicHooks from './Supports/conditional-logic';

import checkbox from './Blocks/Checkbox';
import consent from './Blocks/Consent';
import date from './Blocks/Date';
import dropdown from './Blocks/Dropdown';
import email from './Blocks/Email';
import fileUpload from './Blocks/FileUpload';
import hidden from './Blocks/Hidden';
import html from './Blocks/HTML';
import multiSelect from './Blocks/MultiSelect';
import phone from './Blocks/Phone';
import radio from './Blocks/Radio';
import textarea from './Blocks/Textarea';
import url from './Blocks/URL';

declare global {
    interface Window {
        givewp: {
            form: {
                blocks: {
                    register: (name: string, settings: BlockConfiguration) => void;
                };
                slots: any;
            };
        };
    }
}

window.givewp.form.blocks.register(checkbox.name, checkbox.settings);
window.givewp.form.blocks.register(consent.name, consent.settings);
window.givewp.form.blocks.register(date.name, date.settings);
window.givewp.form.blocks.register(dropdown.name, dropdown.settings);
window.givewp.form.blocks.register(email.name, email.settings);
window.givewp.form.blocks.register(fileUpload.name, fileUpload.settings);
window.givewp.form.blocks.register(hidden.name, hidden.settings);
window.givewp.form.blocks.register(html.name, html.settings);
window.givewp.form.blocks.register(multiSelect.name, multiSelect.settings);
window.givewp.form.blocks.register(phone.name, phone.settings);
window.givewp.form.blocks.register(radio.name, radio.settings);
window.givewp.form.blocks.register(textarea.name, textarea.settings);
window.givewp.form.blocks.register(url.name, url.settings);

registerConditionalLogicHooks();
