import {createHigherOrderComponent} from '@wordpress/compose';
import {useSelect} from '@wordpress/data';

import {Edit} from './Edit';
import './styles.scss';

const flattenBlocks = (block) => [block, ...block.innerBlocks.flatMap(flattenBlocks)];

/**
 * Higher Order Component that adds conditional logic to the inspector controls.
 *
 * @since 3.0.0
 */
const ConditionalLogicHOC = createHigherOrderComponent((BlockEdit) => {
    return (props) => {
        const {attributes, setAttributes, clientId} = props;
        const conditionalLogic = attributes.conditionalLogic;

        // @ts-ignore
        const blocks = useSelect((select) => select('core/block-editor').getBlocks(), []);
        const fieldOptions = [];

        blocks.flatMap(flattenBlocks).forEach((block) => {
            if (block.clientId === clientId || block.name === 'givewp/section') {
                return;
            }

            // TODO: Add support for nested donor name fields.
            if (block.name === 'givewp/donor-name') {
                return;
            }

            if (!block.attributes.label) {
                return;
            }

            return fieldOptions.push({
                label: block.attributes.label,
                value: block.clientId,
            });
        });

        return (
            <>
                <BlockEdit {...props} />
                {attributes.conditionalLogic && fieldOptions.length && (
                    <Edit {...{clientId, conditionalLogic, setAttributes, fieldOptions}} />
                )}
            </>
        );
    };
}, 'withInspectorControl');

export default ConditionalLogicHOC;
