import {useEffect} from '@wordpress/element';
import {Popover} from '@wordpress/components';

import PopoverContent from './PopoverContent';
import PopoverHeader from './PopoverHeader';
import {labels} from '../../constants';
import {ConditionalLogicAttribute, SelectControlOption} from '../../types';

type Props = {
    visible: boolean;
    onClose: () => void;
    setConditionalLogicAttributes: (newAttributes: Partial<ConditionalLogicAttribute>) => void;
    conditionalLogic: ConditionalLogicAttribute;
    fieldOptions: SelectControlOption[];
};

export default function LogicStatementsPopover({
    visible,
    onClose,
    setConditionalLogicAttributes,
    conditionalLogic,
    fieldOptions,
}: Props) {
    if (!visible) {
        return null;
    }

    useEffect(() => {
        return onClose;
    }, []);

    const handleAddRule = (): void => {
        setConditionalLogicAttributes({
            rules: [...conditionalLogic.rules, {field: '', operator: Object.keys(labels.operators)[0], value: ''}],
        });
    };

    const handleRemoveRule = (index: number) => (): void => {
        setConditionalLogicAttributes({
            rules: conditionalLogic.rules.filter((rule, ruleIndex: number) => ruleIndex !== index),
        });
    };

    const handleUpdateRule =
        (index: number) =>
        (key: 'field' | 'operator' | 'value', value: string): void => {
            const rules = [...conditionalLogic.rules];

            rules[index][key] = value;
            setConditionalLogicAttributes({rules});
        };

    return (
        <Popover placement="left-end" offset={28} variant={'unstyled'} focusOnMount={false}>
            <div className={'givewp-conditional-logic__popover-box'}>
                <PopoverHeader onClose={onClose} />
                <PopoverContent
                    conditionalLogic={conditionalLogic}
                    fieldOptions={fieldOptions}
                    onAddRule={handleAddRule}
                    onUpdateRule={handleUpdateRule}
                    onRemoveRule={handleRemoveRule}
                />
            </div>
        </Popover>
    );
}
