import {__} from '@wordpress/i18n';
import {SelectControl, TextControl} from '@wordpress/components';
import {useSelect} from '@wordpress/data';
import {ConditionalLogicRule, SelectControlOption} from '../../types';

type Props = {
    rule: ConditionalLogicRule;
    handleChange: (value: string) => void;
};
export default function ValueField({rule, handleChange}: Props) {
    let valueOptions = [];

    if (rule.field) {
        // @ts-ignore
        const block = useSelect((select) => select('core/block-editor').getBlock(rule.field), null);

        if (block) {
            switch (block.name) {
                case 'givewp-form-field-manager/checkbox':
                    valueOptions.push({
                        label: block.attributes.value,
                    });
                    break;
                case 'givewp-form-field-manager/dropdown':
                case 'givewp-form-field-manager/radio':
                case 'givewp-form-field-manager/multi-select':
                    block.attributes.options.forEach((option: SelectControlOption) => {
                        valueOptions.push({
                            label: option.value || option.label,
                        });
                    });
            }
        }
    }

    if (valueOptions.length) {
        return (
            <SelectControl
                options={[
                    {
                        label: __('Select a value', 'give-form-field-manager'),
                        value: '',
                    },
                    ...valueOptions,
                ]}
                value={rule.value}
                onChange={handleChange}
            />
        );
    }

    return <TextControl placeholder={__('Enter a value', 'give')} value={rule.value} onChange={handleChange} />;
}
