import {__} from '@wordpress/i18n';
import {useEffect} from '@wordpress/element';
import {Button, Popover} from '@wordpress/components';
import {close} from '@wordpress/icons';

import './styles.scss';

type Props = {
    title: string;
    visible: boolean;
    onClose: () => void;
    children: React.ReactNode;
};

export default function StyledPopover({title, visible, onClose, children}: Props) {
    useEffect(() => {
        return onClose;
    }, []);

    if (!visible) {
        return null;
    }

    return (
        <Popover className="givewp-ffm-popover" placement="left" offset={28} variant={'unstyled'} focusOnMount={false}>
            <div className={'givewp-ffm-popover__box'}>
                <div className={'givewp-ffm-popover__header'}>
                    <h1>{title}</h1>
                    <Button onClick={onClose} icon={close} label={__('Close', 'give')} />
                </div>
                <div className={'givewp-ffm-popover__content'}>{children}</div>
            </div>
        </Popover>
    );
}
