import classnames from 'classnames';

import styles from './editor.module.scss';

/**
 * @since 3.0.0
 */
export default function PlaceholderControl({label, isRequired = false, description = '', children}) {
    return (
        <div>
            <span
                className={classnames('components-input-control__label', styles.label, {[styles.required]: isRequired})}
            >
                {label}
            </span>
            {description && <p className={styles.description}>{description}</p>}
            {children}
        </div>
    );
}
