import metadata from './block.json';
import Icon from './Icon';
import PlaceholderControl from '../components/PlaceholderControl';

/**
 * @since 3.0.0
 */
const settings = {
    ...metadata,
    icon: Icon,
    edit: ({attributes}) => {
        const {isRequired, placeholder, defaultValue, label, description} = attributes;

        return (
            <PlaceholderControl label={label} isRequired={isRequired} description={description}>
                <input type="url" placeholder={placeholder} value={defaultValue} readOnly />
            </PlaceholderControl>
        );
    },
};

const url = {
    name: settings.name,
    settings,
};

export default url;
