import {InspectorControls} from '@wordpress/block-editor';
import {TextControl} from '@wordpress/components';
import {__} from '@wordpress/i18n';

import metadata from './block.json';
import Icon from './Icon';
import PlaceholderControl from '../components/PlaceholderControl';

/**
 * @since 3.0.2
 */
const settings = {
    ...metadata,
    icon: Icon,
    edit: ({attributes, setAttributes}) => {
        const {label, placeholder, description, isRequired, defaultValue, rows} = attributes;
        const {FieldSettingsFill} = window.givewp.form.slots;

        return (
            <>
                <InspectorControls>
                    <FieldSettingsFill>
                        <TextControl
                            type="number"
                            label={__('Rows', 'give-form-field-manager')}
                            value={rows}
                            onChange={(rows) => setAttributes({rows})}
                        />
                    </FieldSettingsFill>
                </InspectorControls>
                <PlaceholderControl label={label} isRequired={isRequired} description={description}>
                    <textarea
                        className="components-text-control__input"
                        placeholder={placeholder}
                        rows={rows}
                        value={defaultValue}
                        readOnly
                    />
                </PlaceholderControl>
            </>
        );
    },
};

const textarea = {
    name: settings.name,
    settings,
};

export default textarea;
