import {__} from '@wordpress/i18n';
import {InspectorControls} from '@wordpress/block-editor';
import {SelectControl} from '@wordpress/components';

import metadata from './block.json';
import Icon from './Icon';
import PlaceholderControl from '../components/PlaceholderControl';

/**
 * @since 3.0.0
 */
const settings = {
    ...metadata,
    icon: Icon,
    edit: ({attributes, setAttributes}) => {
        const {label, placeholder, isRequired, description, phoneFormat, defaultValue} = attributes;
        const {FieldSettingsFill} = window.givewp.form.slots;
        const options = [
            {label: __('(###) ###-####', 'give-form-field-manager'), value: 'domestic'},
            {label: __('Unformatted', 'give-form-field-manager'), value: 'unformatted'},
        ];

        return (
            <>
                <InspectorControls>
                    <FieldSettingsFill>
                        <SelectControl
                            label={__('Phone Format', 'give-form-field-manager')}
                            value={phoneFormat}
                            options={options}
                            onChange={(phoneFormat) => setAttributes({phoneFormat})}
                        />
                    </FieldSettingsFill>
                </InspectorControls>
                <PlaceholderControl label={label} isRequired={isRequired} description={description}>
                    <input type="text" placeholder={placeholder} value={defaultValue} readOnly />
                </PlaceholderControl>
            </>
        );
    },
};

const phone = {
    name: settings.name,
    settings,
};

export default phone;
