import {__} from '@wordpress/i18n';
import {InspectorControls} from '@wordpress/block-editor';
import {PanelBody, SelectControl} from '@wordpress/components';
import {OptionsPanel as Options} from '@givewp/form-builder-library';

import metadata from './block.json';
import Icon from './Icon';
import CheckboxPlaceholder from './CheckboxPlaceholder';
import DropdownPlaceholder from './DropdownPlaceholder';

/**
 * @since 3.0.5 Create a deep clone of the options array to remove existing references.
 * @since 3.0.0
 */
const settings = {
    ...metadata,
    icon: Icon,
    edit: ({attributes, setAttributes}) => {
        const {label, description, isRequired, fieldType} = attributes;
        const options = attributes.options.map((option) => ({...option}));
        const checkedOptions = options.filter((option) => option.checked);
        const {FieldSettingsFill, AfterFieldSettingsFill} = window.givewp.form.slots;

        return (
            <>
                <InspectorControls>
                    <FieldSettingsFill>
                        <SelectControl
                            label={__('Type', 'give-form-field-manager')}
                            value={fieldType}
                            options={[
                                {label: __('Dropdown', 'give-form-field-manager'), value: 'dropdown'},
                                {label: __('Checkbox', 'give-form-field-manager'), value: 'checkbox'},
                            ]}
                            onChange={(fieldType) => setAttributes({fieldType})}
                        />
                    </FieldSettingsFill>
                    <AfterFieldSettingsFill>
                        <PanelBody title={__('Options', 'give-form-field-manager')}>
                            <Options
                                multiple={true}
                                options={options}
                                setOptions={(newOptions) => setAttributes({options: newOptions})}
                                showToggle
                            />
                        </PanelBody>
                    </AfterFieldSettingsFill>
                </InspectorControls>
                {fieldType === 'dropdown' ? (
                    <DropdownPlaceholder
                        label={label}
                        isRequired={isRequired}
                        description={description}
                        options={checkedOptions}
                    />
                ) : (
                    fieldType === 'checkbox' && (
                        <CheckboxPlaceholder
                            label={label}
                            isRequired={isRequired}
                            description={description}
                            options={options}
                        />
                    )
                )}
            </>
        );
    },
};

const multiSelect = {
    name: settings.name,
    settings,
};

export default multiSelect;
