import {Icon, Path, Polygon, SVG} from '@wordpress/components';

import PlaceholderControl from '../components/PlaceholderControl';
import './styles.scss';

/**
 * @since 3.0.0
 */
export default function DropdownPlaceholder({label, isRequired, description, options}) {
    return (
        <PlaceholderControl label={label} isRequired={isRequired} description={description}>
            <div className={'give-ffm-multiselect__dropdown'}>
                <ul className={'give-ffm-multiselect__dropdown-options'}>
                    {options.map((option) => (
                        <li key={option.label}>
                            <span>{option.label}</span> <Icon icon={reset} />
                        </li>
                    ))}
                </ul>
                <div className={'give-ffm-multiselect__dropdown-actions'}>
                    {options.length > 0 && (
                        <>
                            <Icon icon={reset} /> <span />
                        </>
                    )}
                    <Icon icon={arrow} />
                </div>
            </div>
        </PlaceholderControl>
    );
}

function arrow() {
    return (
        <SVG width="13px" height="8px" viewBox="0 0 13 8" version="1.1" xmlns="http://www.w3.org/2000/svg">
            <Polygon
                id="Path"
                fill="currentColor"
                fillRule="nonzero"
                points="11.3273072 0.260059927 12.6726528 1.73994007 6.49997878 7.35146191 0.327325867 1.73993886 1.67267413 0.260061144 6.5 4.649"
            ></Polygon>
        </SVG>
    );
}

function reset() {
    return (
        <SVG width="12px" height="12px" viewBox="0 0 12 12" version="1.1" xmlns="http://www.w3.org/2000/svg">
            <Path
                d="M1.61289944,0.209704612 L1.70710678,0.292893219 L6,4.585 L10.2928932,0.292893219 C10.6834175,-0.0976310729 11.3165825,-0.0976310729 11.7071068,0.292893219 C12.0675907,0.65337718 12.0953203,1.22060824 11.7902954,1.61289944 L11.7071068,1.70710678 L7.415,6 L11.7071068,10.2928932 C12.0976311,10.6834175 12.0976311,11.3165825 11.7071068,11.7071068 C11.3466228,12.0675907 10.7793918,12.0953203 10.3871006,11.7902954 L10.2928932,11.7071068 L6,7.415 L1.70710678,11.7071068 C1.31658249,12.0976311 0.683417511,12.0976311 0.292893219,11.7071068 C-0.0675907428,11.3466228 -0.0953202783,10.7793918 0.209704612,10.3871006 L0.292893219,10.2928932 L4.585,6 L0.292893219,1.70710678 C-0.0976310729,1.31658249 -0.0976310729,0.683417511 0.292893219,0.292893219 C0.62333685,-0.0375504127 1.12750547,-0.0883878944 1.51140295,0.140380774 L1.61289944,0.209704612 Z"
                id="Shape"
                fill="currentColor"
                fillRule="nonzero"
            ></Path>
        </SVG>
    );
}
