import PlaceholderControl from '../components/PlaceholderControl';
import './styles.scss';

/**
 * @since 3.0.0
 */
export default function CheckboxPlaceholder({label, isRequired, description, options}) {
    return (
        <PlaceholderControl label={label} isRequired={isRequired} description={description}>
            <div className={'give-ffm-multiselect__checkbox'}>
                {options.map((option) => (
                    <label key={option.label}>
                        <input type="checkbox" checked={option.checked} readOnly />
                        {option.label}
                    </label>
                ))}
            </div>
        </PlaceholderControl>
    );
}
