import metadata from './block.json';
import Icon from './Icon';
import PlaceholderControl from '../components/PlaceholderControl';

/**
 * @since 3.0.0
 */
const settings = {
    ...metadata,
    icon: Icon,
    edit: ({attributes}) => {
        const {label, defaultValue} = attributes;

        return (
            <PlaceholderControl label={label}>
                <input type="text" value={defaultValue} readOnly />
            </PlaceholderControl>
        );
    },
};

const hidden = {
    name: settings.name,
    settings,
};

export default hidden;
