import {__} from '@wordpress/i18n';
import {InspectorControls} from '@wordpress/block-editor';

import metadata from './block.json';
import Icon from './Icon';
import CodeEditor from './CodeEditor';
import './styles.scss';

/**
 * @since 3.0.0
 */
const settings = {
    ...metadata,
    icon: Icon,
    edit: ({attributes, setAttributes}) => {
        const {label, htmlCode} = attributes;
        const {FieldSettingsFill} = window.givewp.form.slots;

        return (
            <>
                <InspectorControls>
                    <FieldSettingsFill>
                        <p className={'components-base-control__help give-ffm-html__help'}>
                            {__(
                                'This field is only for site admin reference and will not be output on the front end.',
                                'give-form-field-manager'
                            )}
                        </p>
                        <CodeEditor value={htmlCode} onChange={(htmlCode) => setAttributes({htmlCode})} />
                    </FieldSettingsFill>
                </InspectorControls>
                <div className={'give-ffm-html__placeholder'}>
                    <span>{label}</span>
                </div>
            </>
        );
    },
};

const html = {
    name: settings.name,
    settings,
};

export default html;
