import metadata from './block.json';
import Icon from './Icon';
import PlaceholderControl from '../components/PlaceholderControl';

/**
 * @since 3.0.0
 */
const settings = {
    ...metadata,
    icon: Icon,
    edit: ({attributes}) => {
        const {label, placeholder, description, isRequired, defaultValue} = attributes;

        return (
            <>
                <PlaceholderControl label={label} isRequired={isRequired} description={description}>
                    <input type="email" value={defaultValue} placeholder={placeholder} readOnly />
                </PlaceholderControl>
            </>
        );
    },
};

const email = {
    name: settings.name,
    settings,
};

export default email;
