import {__} from '@wordpress/i18n';
import {InspectorControls} from '@wordpress/block-editor';
import {PanelBody} from '@wordpress/components';
import {OptionsPanel as Options} from '@givewp/form-builder-library';

import metadata from './block.json';
import Icon from './Icon';
import PlaceholderControl from '../components/PlaceholderControl';
import './styles.scss';

/**
 * @since 3.0.5 Create a deep clone of the options array to remove existing references.
 * @since 3.0.0
 */
const settings = {
    ...metadata,
    icon: Icon,
    edit: ({attributes, setAttributes}) => {
        const {label, description, isRequired} = attributes;
        const options = attributes.options.map((option) => ({...option}));
        const checkedOptions = options.filter((option) => option.checked);
        const {AfterFieldSettingsFill} = window.givewp.form.slots;

        return (
            <>
                <InspectorControls>
                    <AfterFieldSettingsFill>
                        <PanelBody title={__('Options', 'give-form-field-manager')}>
                            <Options
                                multiple={false}
                                options={options}
                                setOptions={(newOptions) => setAttributes({options: newOptions})}
                                showToggle
                            />
                        </PanelBody>
                    </AfterFieldSettingsFill>
                </InspectorControls>
                <PlaceholderControl label={label} isRequired={isRequired} description={description}>
                    <select className={'give-ffm-dropdown'}>
                        {checkedOptions.map((option) => (
                            <option value={option.value}>{option.label}</option>
                        ))}
                    </select>
                </PlaceholderControl>
            </>
        );
    },
};

const dropdown = {
    name: settings.name,
    settings,
};

export default dropdown;
