import {__} from '@wordpress/i18n';
import {InspectorControls} from '@wordpress/block-editor';
import {SelectControl} from '@wordpress/components';

import metadata from './block.json';
import Icon from './Icon';
import PlaceholderControl from '../components/PlaceholderControl';

/**
 * @since 3.0.0
 */
const settings = {
    ...metadata,
    icon: Icon,
    edit: ({attributes, setAttributes}) => {
        const {label, isRequired, description, dateFormat} = attributes;
        const {FieldSettingsFill} = window.givewp.form.slots;
        const options = [
            {label: 'mm/dd/yyyy', value: 'mm/dd/yyyy'},
            {label: 'dd/mm/yyyy', value: 'dd/mm/yyyy'},
            {label: 'yyyy/mm/dd', value: 'yyyy/mm/dd'},
        ];

        return (
            <>
                <InspectorControls>
                    <FieldSettingsFill>
                        <SelectControl
                            label={__('Date Format', 'give-form-field-manager')}
                            value={dateFormat}
                            options={options}
                            onChange={(dateFormat) => setAttributes({dateFormat})}
                        />
                    </FieldSettingsFill>
                </InspectorControls>
                <PlaceholderControl label={label} isRequired={isRequired} description={description}>
                    <input type="text" placeholder={dateFormat} readOnly />
                </PlaceholderControl>
            </>
        );
    },
};

const date = {
    name: settings.name,
    settings,
};

export default date;
