import {InspectorControls} from '@wordpress/block-editor';
import {CheckboxControl, PanelRow, TextControl, ToggleControl} from '@wordpress/components';
import {__} from '@wordpress/i18n';

import metadata from './block.json';
import Icon from './Icon';
import cx from 'classnames';
import './styles.scss';

/**
 * @since 3.0.5 replace native checkbox with CheckboxControl.
 * @since 3.0.0
 */
const settings = {
    ...metadata,
    icon: Icon,
    edit: ({attributes, setAttributes}) => {
        const {isRequired, checked, showValue, label, value} = attributes;
        const {FieldSettingsFill} = window.givewp.form.slots;

        return (
            <>
                <InspectorControls>
                    <FieldSettingsFill>
                        <PanelRow>
                            <ToggleControl
                                label={__('Checked by default', 'give-form-field-manager')}
                                checked={checked}
                                onChange={() => setAttributes({checked: !checked})}
                            />
                        </PanelRow>
                        <PanelRow>
                            <ToggleControl
                                label={__('Show value', 'give-form-field-manager')}
                                checked={showValue}
                                onChange={() => setAttributes({showValue: !showValue})}
                            />
                        </PanelRow>
                        {showValue && (
                            <PanelRow>
                                <TextControl
                                    label={__('Value', 'give-form-field-manager')}
                                    value={value}
                                    onChange={(value) => setAttributes({value})}
                                    help={__('The value for the checkbox', 'give-form-field-manager')}
                                />
                            </PanelRow>
                        )}
                    </FieldSettingsFill>
                </InspectorControls>

                <CheckboxControl
                    className={cx('give-ffm-checkbox', {
                        ['give-ffm-checkbox__required']: isRequired,
                    })}
                    readOnly
                    checked={checked}
                    label={label}
                    onChange={null}
                    disabled={true}
                />
            </>
        );
    },
};

const checkbox = {
    name: settings.name,
    settings,
};

export default checkbox;
