<?php

namespace GiveFormFieldManager\FormExtension\DonationForm\Rules;

use Closure;
use Give\Vendors\StellarWP\Validation\Contracts\ValidatesOnFrontEnd;
use Give\Vendors\StellarWP\Validation\Contracts\ValidationRule;

/**
 * @unrleased
 */
class UrlRule implements ValidationRule, ValidatesOnFrontEnd
{
    /**
     * @inheritDoc
     *
     * @unrleased
     */
    public static function id(): string
    {
        return 'url';
    }

    /**
     * @inheritDoc
     *
     * @unrleased
     */
    public static function fromString(string $options = null): ValidationRule
    {
        return new self();
    }

    /**
     * @inheritDoc
     */
    public function serializeOption()
    {
        return null;
    }

    /**
     * @inheritDoc
     *
     * @unrleased
     */
    public function __invoke($value, Closure $fail, string $key, array $values)
    {
        if (!is_string($value) || !filter_var($value, FILTER_VALIDATE_URL)) {
            $fail(sprintf(__('%s is not a valid URL', 'give-form-field-manager'), '{field}'));
        }
    }
}
