<?php

namespace GiveFormFieldManager\FormExtension\DonationForm\Rules;

use Closure;
use Give\Vendors\StellarWP\Validation\Contracts\ValidationRule;

/**
 * @unrleased
 */
class MultiSelectFieldRule implements ValidationRule
{
    /**
     * @var array
     */
    protected $options;

    /**
     * @since 3.1.0
     */
    public function __construct(array $options = [])
    {
        $this->options = $options;
    }

    /**
     * @inheritDoc
     *
     * @unrleased
     */
    public static function id(): string
    {
        return 'multiSelectField';
    }

     /**
     * @inheritDoc
     *
     * @since 3.1.0
     */
    public static function fromString(string $options = null): ValidationRule
    {
        return new self((array)$options);
    }

    /**
     * @inheritDoc
     *
     * @unrleased
     */
    public function __invoke($value, Closure $fail, string $key, array $values)
    {
        foreach ((array)$value as $v) {
            if (!in_array($v, $this->options, true)) {
                $fail(sprintf(__('%s must be one of: %s', 'give'), '{field}', implode(', ', $this->options)));
            }
        }
    }
}
