<?php

namespace GiveFormFieldManager\FormExtension\DonationForm\Rules;

use Closure;
use Give\Vendors\StellarWP\Validation\Contracts\Sanitizer;
use Give\Vendors\StellarWP\Validation\Contracts\ValidationRule;

/**
 * @unrleased
 */
class ConsentFieldRule implements ValidationRule, Sanitizer
{
    /**
     * @inheritDoc
     *
     * @unrleased
     */
    public static function id(): string
    {
        return 'consentField';
    }

     /**
     * @inheritDoc
     *
     * @since 3.1.0
     */
    public static function fromString(string $options = null): ValidationRule
    {
        return new self();
    }

    /**
     * @inheritDoc
     *
     * @unrleased
     */
    public function __invoke($value, Closure $fail, string $key, array $values)
    {
        if ($value !== 'accepted' && !is_bool(filter_var($value, FILTER_VALIDATE_BOOLEAN, FILTER_NULL_ON_FAILURE))) {
            $fail(sprintf(__('%s must be accepted', 'give'), '{field}'));
        }
    }

    /**
     * @since 3.1.0
     */
    public function sanitize($value)
    {
        return filter_var($value, FILTER_VALIDATE_BOOLEAN);
    }
}
