<?php

namespace GiveFormFieldManager\FormExtension\DonationForm\Rules;

use Closure;
use Give\Vendors\StellarWP\Validation\Contracts\Sanitizer;
use Give\Vendors\StellarWP\Validation\Contracts\ValidationRule;

/**
 * @unrleased
 */
class CheckboxFieldRule implements ValidationRule, Sanitizer
{
    /**
     * @var string
     */
    protected $value;

    /**
     * @since 3.1.0
     */
    public function __construct(string $value)
    {
        $this->value = $value;
    }

    /**
     * @inheritDoc
     *
     * @unrleased
     */
    public static function id(): string
    {
        return 'checkboxField';
    }

     /**
     * @inheritDoc
     *
     * @since 3.1.0
     */
    public static function fromString(string $options = null): ValidationRule
    {
        return new self($options);
    }

    /**
     * @inheritDoc
     *
     * @unrleased
     */
    public function __invoke($value, Closure $fail, string $key, array $values)
    {
        if ($value !== $this->value && !is_bool(filter_var($value, FILTER_VALIDATE_BOOLEAN, FILTER_NULL_ON_FAILURE))) {
            $fail(sprintf(__('%s must be %s', 'give'), '{field}', $this->value));
        }
    }

    /**
     * @since 3.1.0
     */
    public function sanitize($value)
    {
        return filter_var($value, FILTER_VALIDATE_BOOLEAN);
    }
}
