<?php

namespace GiveFormFieldManager\FormExtension\DonationForm\Actions;

use Give\Framework\Blocks\BlockModel;
use Give\Framework\FieldsAPI\Contracts\Node;
use Give\Framework\FieldsAPI\DonationForm;

/**
 * @since 3.0.0
 */
class MapConditionalLogicToFields
{
    /**
     * @var array {blockClientId: {node: Node, block: BlockModel}}
     */
    protected $blockNodeRelationships = [];

    /**
     * @since 3.0.0
     *
     * @return void
     */
    public function __invoke(DonationForm $form, int $formId, array $blockNodeRelationships)
    {
        $this->blockNodeRelationships = $blockNodeRelationships;

        foreach ($this->blockNodeRelationships as $item) {
            $this->mapConditionalLogicAttributesToNode($item['node'], $item['block']);
        }
    }

    /**
     * @since 3.0.1 replaces donationAmount field name with amount
     * @since 3.0.0
     *
     * @return void
     */
    protected function mapConditionalLogicAttributesToNode(Node $node, BlockModel $block)
    {
        if (!$block->hasAttribute('conditionalLogic') || !method_exists($node, 'showIf')) {
            return;
        }

        $conditionalLogic = $block->getAttribute('conditionalLogic');

        if ($conditionalLogic['enabled'] !== true || !is_array($conditionalLogic['rules'])) {
            return;
        }

        $action = $conditionalLogic['action'] ?? 'show';
        $boolean = $conditionalLogic['boolean'] ?? 'and';
        $rules = $conditionalLogic['rules'];

        if ('hide' === $action) {
            $boolean = 'and' === $boolean ? 'or' : 'and';
        }

        $oppositeOperatorsMap = [
            '=' => '!=',
            '!=' => '=',
            '>' => '<=',
            '<' => '>=',
            '>=' => '<',
            '<=' => '>',
        ];

        foreach ($rules as $rule) {
            if (!isset($rule['field'], $rule['operator'], $rule['value'])) {
                continue;
            }

            $clientId = $rule['field'];
            $operator = $rule['operator'];
            $value = $rule['value'];

            // TODO: Add support for nested fields
            $fieldName = $this->blockNodeRelationships[$clientId]['node']->getName();
            if ($fieldName === 'donationAmount') {
                $fieldName = 'amount';
            }

            if ('hide' === $action) {
                if (isset($oppositeOperatorsMap[$operator])) {
                    $operator = $oppositeOperatorsMap[$operator];
                } else {
                    continue;
                }
            }

            $node->showIf($fieldName, $operator, $value, $boolean);
        }
    }
}
