<?php

namespace GiveFormFieldManager\Donations\Actions;

use GiveFormFieldManager\Helpers\Form;

/**
 * @since 3.2.0
 */
class GenerateDonationDetailCustomFields
{
    /**
     * @since 3.2.0
     */
    public function __invoke(array $customFields, $donationId)
    {
        $ffmFields = Form::getSavedCustomFields($donationId);

        if (empty($ffmFields)) {
            return $customFields;
        }

        foreach ($ffmFields as $field) {
            $fieldValue = $this->getFieldValue($field);

            $customFields[] = [
                'label' => $field['label'],
                'value' => $fieldValue,
            ];
        }

        return $customFields;
    }

    /**
     * @since 3.2.0
     */
    private function getFieldValue(array $field): string
    {
        if (is_string($field['value'])) {
            return $field['value'];
        }

        // this is a special snowflake that can have multiple columns so we need to handle it differently
        if ($field['input_type'] === 'repeat') {
            $columns = $field['columns'];
            $values = $field['value'];

            $fieldValuePairs = [];

            // Map each value to its corresponding column label
            foreach ($values as $key => $value) {
                if (isset($columns[$key]) && !empty($value)) {
                    $columnLabel = $columns[$key] ?? $key;
                    $fieldValuePairs[] = $columnLabel . ': ' . $value;
                }
            }

            return implode(', ', $fieldValuePairs);
        }

        // if any other type of field, we can just return the value in comma separated format
        if (is_array($field['value'])) {
            return implode(', ', $field['value']);
        }

        return (string) $field['value'];
    }
}
