<?php
/**
 * Woocommerce block based API integration - in progress
 * @version 2.4.19
 */

class EVOTX_WC_Store_API {

	public function __construct(){
		add_action( 'woocommerce_store_api_checkout_order_processed', array($this,'process_ticket_order'),10, 1 );

		add_filter('woocommerce_store_api_product_quantity_limit', [$this, 'WCAPI_quantity_limit'], 10, 2);
	    add_action('woocommerce_store_api_checkout_order_processed', [$this, 'create_evo_tickets_for_store_api'], 10, 1);
	    add_filter('woocommerce_store_api_cart_items', [$this, 'sync_store_api_cart_items'], 10, 1);
	}

	// WC rest cart max quantity @2.4
	public	function WCAPI_quantity_limit($max, $product){

		if( !WC()->cart || empty( WC()->cart)) return $max;

		foreach ( WC()->cart->get_cart() as $cart_item ) {
			if( !isset($cart_item['evotx_event_id_wc'])) continue;
			if( !isset($cart_item['product_id'])) continue;
			if( $cart_item['product_id'] != $product->get_id() ) continue;

			return apply_filters('evotx_cart_item_max_qty', $max, $product, $cart_item);
		}

		return $max;
	}

	// Woo store API checkout
	public function create_evo_tickets_for_store_api($order) {
	    if (!($order instanceof WC_Order)) {
	        return;
	    }

	    // Prevent duplicate ticket creation
	    if ($order->get_meta('_evotx_tickets_created') === 'yes') {
	        return;
	    }

	    // Call the existing ticket creation function
	    $ET = new evotx_tix();
	    $ET->create_tickets_for_order($order);

	    // Mark order as having tickets created
	    $order->update_meta_data('_evotx_tickets_created', 'yes');
	    $order->save();

	    // Reduce stock
	    if ($order->get_meta('evo_stock_reduced') !== 'yes') {
	        $this->adjust_ticket_var_stock($order->get_id(), 'reduce', 'cart');
	    }

	    // Auto-complete order if configured
	    if (EVO()->cal->check_yn('evotx_autocomplete', 'evcal_tx')) {
	        $order->update_status('completed', __('Order auto-completed for ticket generation (express checkout).', 'evotx'));
		}

		// Redirect to ticket holder form if additional data is needed
	    $needs_ticketholder_data = false;
	    foreach ($order->get_items() as $item) {
	        if ($item->get_product()->get_meta('_eventid')) {
	            $needs_ticketholder_data = true;
	            break;
	        }
	    }
	    if ($needs_ticketholder_data) {
	        $order->update_meta_data('_needs_ticketholder_data', 'yes');
	        $order->save();
	        add_filter('woocommerce_get_checkout_order_received_url', function($url, $order) {
	            // Only redirect to view-order page if user is logged in and ticketholder data is needed
		        if (is_user_logged_in() && $order->get_meta('_needs_ticketholder_data') === 'yes') {
		            return $order->get_view_order_url();
		        }
	            return $url;
	        }, 10, 2);
	    }
	}

	public function sync_store_api_cart_items($cart_items) {
	    $wc_cart = WC()->cart->get_cart();
	    $synced_items = [];

	    foreach ($wc_cart as $cart_item_key => $cart_item) {
	        $synced_items[] = [
	            'key' => $cart_item_key,
	            'id' => $cart_item['product_id'],
	            'quantity' => $cart_item['quantity'],
	            'data' => $cart_item['data'],
	            'data_context' => 'cart',
	            'custom_data' => isset($cart_item['evotx_event_id_wc']) ? $cart_item : [],
	        ];
	    }

	    return $synced_items;
	}

	function process_ticket_order( $order){
		$ET = new evotx_tix();
		$ET->create_tickets_for_order( $order );		
	}
}