<?php
/**
 * Intergration with ActionUser Addon
 * @version 2.3.2
 * @actionuser_version 2.4.6
 */
class evotx_actionuser{
	public function __construct(){

		// stop doing anything if actionUser is not there
		if(!class_exists('eventon_au')) return false;

		add_filter('evoau_form_fields', array($this, 'fields_to_form'), 10, 1);

		// only for frontend
		// actionUser intergration
		add_action('evoau_frontform_evotx', array($this, 'fields'), 10, 7);	

		add_action('evoau_save_formfields', array($this, 'save_values'), 10, 5);
		add_action('evoau_frontend_scripts_enqueue', array($this, 'enqueue_scripts'), 10);

		// event manager
		add_action('evoau_manager_row_title', array($this, 'event_manager_row_title'), 10, 1);
		add_action('evoau_manager_row', array($this, 'event_manager_row'), 10, 1);
		//add_action('evoauem_custom_action', array($this, 'event_manager_show_data'), 10, 1);
		add_filter('evoau_event_manager_delete_btn', array($this, 'event_manager_delete_btn'),10,2);

		// ajax filters
		add_action( 'wp_ajax_evotx_ajax_get_auem_stats', array( $this, 'evors_ajax_get_auem_stats' ) );
		add_action( 'wp_ajax_nopriv_evotx_ajax_get_auem_stats', array( $this, 'evors_ajax_get_auem_stats' ) );

		// user capability
		add_filter('eventon_core_capabilities',array($this, 'capability'),10, 1);

		// only admin fields
		if(is_admin()){
			add_filter('eventonau_language_fields', array($this, 'language'), 10, 1);
		}
	}

	// capabilities support for AU
		function capability($array){
			//$array[] = '';
			return $array;
		}
	// include ticket script
		function enqueue_scripts(){
			wp_enqueue_script('tx_wc_tickets');
		}

	// include fields to submission form array
		function fields_to_form($array){
			$array['evotx']=array('Ticket Fields', 'evotx_tix', 'evotx','custom','');
			return $array;
		}

	// Frontend showing fields and saving values  
		function fields($field, $event_id, $default_val, $EPMV, $opt2, $lang, $auform){

			$form = $auform;

			$evotx_tix = ($EPMV && !empty($EPMV['evotx_tix']) && $EPMV['evotx_tix'][0]=='yes')? true: false;


			echo $auform->get_form_html(
				'evotx_tix',
				array(
					'type'=>'yesno',
					'yesno_args'=>array(
						'id'=>'evotx_tix',
						'input'=>true,
						'label'=>evo_lang('Sell tickets for this event'),
						'var'=> ($auform->EVENT && $auform->EVENT->check_yn('evotx_tix')?'yes':'no'),
						'afterstatement'=>'evotx_data_section',
						'lang'=>$lang,
					)
				)
			);

			// for editting
				$_regular_price = $_sale_price = $_stock = $_sku = $product = $woometa = '';
				$wc_ticket_product_id = !empty($EPMV['tx_woocommerce_product_id'])? $EPMV['tx_woocommerce_product_id'][0]: false;
				if($wc_ticket_product_id){
					$woometa = get_post_custom($wc_ticket_product_id);

					$product = wc_get_product($wc_ticket_product_id);
					
					if(!empty($woometa['_regular_price']) )	$_regular_price = $woometa['_regular_price'][0];
					if(!empty($woometa['_sale_price']) )	$_sale_price = $woometa['_sale_price'][0];
					if(!empty($woometa['_stock']) )	$_stock = $woometa['_stock'][0];
					if(!empty($woometa['_sku']) )	$_sku = $woometa['_sku'][0];
				}

				$au_tx_fields_array = array();

			// non simple item notice
				if( ($product && !$product->is_type('simple'))){

					echo "<div id='evotx_data_section' class='row evoau_sub_formfield' style='display:".($evotx_tix?'':'none')."'>";
						echo "<p class=''>". evo_lang('This is a non-simple WC Ticket, must contact admin to make further edits!') . "</p>";
					echo "</div>";
					return;
				}
				
			
			echo "<div id='evotx_data_section' class='row evoau_sub_formfield' style='display:".($evotx_tix?'':'none')."'>";

			EVO()->elements->print_hidden_inputs(array(
				'tx_product_type'=> 'simple',
				'visibility'=> 'visible',
				'tx_woocommerce_product_id'=> $wc_ticket_product_id
			));

			$__woo_currencySYM = get_woocommerce_currency_symbol();


			echo EVO()->elements->process_multiple_elements(
				array(

					array(
						'id'=> '_regular_price',
						'type'=>	'text',
						'name'=>	evo_lang('Ticket Price',$lang, $opt2) . ' ('. evo_lang('Required').' *)'.' ('.$__woo_currencySYM .')',
						'value'=>	evo_var_val($woometa, '_regular_price'),
						//'row_class'=>' req',
						'req_dep'=>	array('name'=>'evotx_tix','value'=>'yes'),
						'nesting_start'=> 'evotx_1',
					),
					array(
						'id'=>'_sale_price',
						'type'=>	'text',
						'name'=>	evo_lang('Ticket Sales Price',$lang, $opt2).' ('.$__woo_currencySYM .')',
						'value'=>	evo_var_val($woometa, '_sale_price'),
						'row_class'=>' ',		
					),array(
						'id'=>'_sku',
						'type'=>	'text',
						'name'=>	evo_lang('SKU',$lang, $opt2),
						'value'=>	evo_var_val($woometa, '_sku'),
						'tooltip'=>	evo_lang('SKU refers to a Stock-keeping unit, a unique identifier for each distinct menu item that can be ordered. You must enter a SKU or else the tickets might not function correct.'),
						'row_class'=>' ',
						'nesting_end'=> true,				
					),
					array(
						'id'=>'_manage_stock',
						'type'=> 'yesno_btn',
						'value'=> ($auform->EVENT && $auform->EVENT->check_yn('_manage_stock')?'yes':'no'),
						'label'=> evo_lang('Manage Ticket Stock'),'lang'=>$lang,
						'afterstatement'=>'_manage_stock1'
					),
						array(
							'type'=>'begin_afterstatement','id'=>'_manage_stock1', 
							'value'=>($auform->EVENT && $auform->EVENT->check_yn('_manage_stock')?'yes':'no'),		
						),
						array(
							'id'=>'_stock',
							'type'=>	'text',
							'name'=>	evo_lang('Ticket Stock Capacity'),
							'value'=>	evo_var_val($woometa, '_stock'),
							'tooltip'=>evo_lang('This is how many tickets you have currently in stock.')					
						),
						array('type'=>'end_afterstatement'	),
					array(				
						'type'=>'yesno_btn',
						'id'=>'_sold_individually',
						'input'=>true,
						'label'=>evo_lang('Sold Individually'),
						'value'=> (evo_check_yn($woometa, '_sold_individually')?'yes':'no'),
						'lang'=>$lang,
						'tooltip'=> evo_lang('Enable this to only allow one ticket per person'),
					),array(				
						'type'=>'yesno_btn',
						'id'=>'_show_remain_tix',
						'input'=>true,
						'label'=>evo_lang('Show remaining tickets'),
						'value'=> (evo_check_yn($EPMV, '_show_remain_tix')?'yes':'no'),
						'tooltip'=> evo_lang('This will show remaining tickets for this event on front-end'),
						'afterstatement'=>'remaining_count__',	
					),	
						array(
							'type'=>'begin_afterstatement','id'=> 'remaining_count__',
							'value'=> ($auform->EVENT && $auform->EVENT->check_yn('remaining_count')?'yes':'no'),				
						),
						array(
							'id'=> 'remaining_count',
							'type'=>	'text',
							'name'=>	evo_lang('Show remaining count at',$lang, $opt2),
							'value'=>	evo_var_val($EPMV, 'remaining_count'),
							'tooltip'=>	evo_lang('Show remaining count when remaining count go below this number.')	,
							'row_class'=>'',										
						),
						array('type'=>'end_afterstatement',	),
					array(
						'type'=>'yesno_btn',
						'label'=>evo_lang('Show guest list for event on eventCard'),
						'id'=> '_tx_show_guest_list',
						'value'=> ($auform->EVENT && $auform->EVENT->check_yn('_tx_show_guest_list')?'yes':'no'),				
					),
					array(
						'type'=>'yesno_btn',
						'label'=>evo_lang('Allow customers to submit inquiries.'),
						'tooltip'=>'With this customers can submit inquiries via this form before buying tickets on front-end.',
						'id'=> '_allow_inquire',
						'value'=> ($auform->EVENT && $auform->EVENT->check_yn('_allow_inquire')?'yes':'no'),
						'afterstatement'=>'_allow_inquire__',				
					),
						array(
							'type'=>'begin_afterstatement','id'=> '_allow_inquire__',
							'value'=> ($auform->EVENT && $auform->EVENT->check_yn('_allow_inquire')?'yes':'no'),				
						),
						array(
							'type'=>'text',
							'name'=>evo_lang('Email Address to receive Inquiries'),
							'id'=> '_tx_inq_email',
							'value'=> ($auform->EVENT ? $auform->EVENT->get_prop('_tx_inq_email') :''),
						),array(
							'type'=>'text',
							'name'=>evo_lang('Subject for Inquiries Email'),
							'id'=> '_tx_inq_subject',
							'value'=> ($auform->EVENT ? $auform->EVENT->get_prop('_tx_inq_subject') :''),
						),
						array('type'=>'end_afterstatement'	),
					array(
						'id'=>'_tx_text',
						'type'=> 'input',
						'value'=> ($auform->EVENT ? $auform->EVENT->get_prop('_tx_text') :''),
						'name'=> evo_lang('Ticket Section Subtitle'),
						'tooltip'=> evo_lang('This text will appear right under the ticket section title in eventcard')
					),
				)
			);

			echo "</div>";
		}

		// save form submission values
		function save_values($field, $fn, $event_id, $event, $post_data ){
			if( $field =='evotx'){					
				if(!empty($post_data['evotx_tix']) && $post_data['evotx_tix']=='yes'){

					// adjust $post_data array
						if(!empty($post_data['_stock']))	$post_data['_manage_stock'] = 'yes';

					update_post_meta($event_id, 'evotx_tix', $post_data['evotx_tix']);
					
					// Update Event
					foreach(array(
						'_manage_stock',
						'_show_remain_tix',
						'_tx_show_guest_list',
						'remaining_count',
						'_allow_inquire',
						'_tx_inq_email',
						'_tx_inq_subject',
						'_tx_text'
					) as $field){
						if(empty($post_data[$field])) continue;

						update_post_meta($event_id, $field, $post_data[$field]);
					}


					$EVENT = new EVOTX_Event( $event_id );


					// Update associated WC object
					$create_new = false;

					if( isset($post_data['tx_woocommerce_product_id']) && !empty($post_data['tx_woocommerce_product_id'])){
							
						$product_id = (int)$post_data['tx_woocommerce_product_id'];
						$post_exists = $this->post_exist( $product_id );

						if($post_exists){

							$EVENT->update_wc_product( $product_id , $post_data );
							
						}else{
							$create_new = true;	
						}
					}else{ // add new 
						$create_new = true;	
					}

					if( $create_new ){
						$product_id = $EVENT->create_wc_product( $post_data );		
					}
				}
			}
		}

		function post_exist($ID){
			global $wpdb;

			$post_id = $ID;
			$post_exists = $wpdb->get_row("SELECT * FROM $wpdb->posts WHERE id = '" . $post_id . "'", 'ARRAY_A');
			return $post_exists;
		}
	
	// event manager additions
		function event_manager_row_title($EVENT){
			$wc_ticket_product_id = $EVENT->get_prop('tx_woocommerce_product_id');
			
			if($EVENT->check_yn('evotx_tix') && $wc_ticket_product_id){
				echo "<tags style='background-color:#8BDBEC'>".evo_lang('Ticket Sales On')."</tags>";
			}
		}
		function event_manager_row($EVENT){
			$wc_ticket_product_id = $EVENT->get_prop('tx_woocommerce_product_id');

			if($EVENT->check_yn('evotx_tix') && $wc_ticket_product_id){
				echo "<a class='evoauem_additional_buttons load_tix_stats' data-eid='{$EVENT->ID}' data-ri='{$EVENT->ri}'>".evo_lang('View Ticket Stats')."</a>";
			}
		}

		function evors_ajax_get_auem_stats(){
			$html = $this->event_manager_show_data($_POST['eid']);
			echo json_encode(array(
				'status'=>'good',
				'html'=>$html
			));exit;
		}

		function event_manager_show_data($event_id){

			ob_start();

			$event = new EVOTX_Event( $event_id );
			
			$wc_ticket_product_id = $event->get_wcid();

			if(!$wc_ticket_product_id) return;

			$product_type = $event->get_product_type();
			$__woo_currencySYM = get_woocommerce_currency_symbol();

			?>
			<div id='' class='evoau_manager_continer' style='padding:15px;'>
				<h3 class="evoauem_section_subtitle" style='margin-bottom: 10px;'><?php evo_lang_e('Event');?>: <b><?php echo $event->get_title();?></b> <i class='evoau_information_bubble' style=''><?php evo_lang_e('Event Ticket Information & Stats');?></i></h3>


				<div id="" class='evoau_tile' style=''>
					<h4 style='margin:0'><?php evo_lang_e('Ticket Information');?></h4>

					<?php $_sty_1 = 'padding:0 0 5px;margin:0';?>
					<div style=''>
						<p style='<?php echo $_sty_1;?>'><b><?php evo_lang_e('Price');?>:</b>
							<span><?php
							if($product_type=='variable'){
								echo $__woo_currencySYM . ' '. $event->get_product_meta('_min_variation_price') .' - '.$event->get_product_meta( '_max_variation_price');
							}else{
								echo $__woo_currencySYM . ' '. $event->get_product_regular_price();
							}
							?></span>
						<?php 
						// ticket stock status
						if( $event->is_product_manage_stock() ):?>
							<?php
								if($product_type == 'simple'):
									$tix_inStock = $event->has_tickets();
							?>
								<p><b><?php evo_lang_e('Tickets in stock');?></b>
									<span><?php echo  evo_lang($tix_inStock);?></span></p>
							<?php endif;?>
						<?php endif;?>
						</p>

						<?php 
						// product type translated text
							$p_text = $product_type;
							if( $product_type == 'variable') $p_text = evo_lang('Variable');
							if( $product_type == 'simple') $p_text = evo_lang('Simple');

						?>
						<p style='<?php echo $_sty_1;?>'><b><?php evo_lang_e('Tickets Type');?>:</b> <i><?php echo $product_type;?></i></p>
						<p style='<?php echo $_sty_1;?>'><b><?php evo_lang_e('SKU');?>:</b> <i><?php echo $event->get_product_sku();?></i></p>
						<?php if( $event->is_product_manage_stock() ):?>
							<p style='<?php echo $_sty_1;?>'><b><?php evo_lang_e('Stock Status');?>:</b> <i><?php echo evo_lang( $event->get_product_stock_status() );?></i></p>
						<?php endif;?>
					</div>
				</div>

				<div id="" class='evoau_tile' style=''>
					<h4 style='margin:0'><?php evo_lang_e('Attendees');?></h4>
					<?php 							
						$EA = new EVOTX_Attendees();
						$TH = $EA->get_tickets_for_event($event_id);

						// can user check guests for event tickets
							$_can_check = false;

							// if allow event creator to checkin guests enabled via tickets settings
							if( EVO()->cal->check_yn('evotx_checkin_guests','evcal_tx')) $_can_check = true; 

							// can user edit event via AU function
							$_au_can_user_edit_event = EVOAU()->frontend->functions->can_currentuser_edit_event($event_id );

							// override actionUser permission
							if( !$_au_can_user_edit_event ) $_can_check = false;

							// if admin of the site override all and allow
							if($EA->_user_can_check()) $_can_check = true;

						if($TH && count($TH)>0){
							echo "<div class='event_tix_attendee_list'>";

							foreach($TH as $tn=>$td){

								echo $EA->__display_one_ticket_data($tn, $td, array(
									'showStatus'=> $_can_check,
									'showOrderStatus'=>true,
									'guestsCheckable'=>$_can_check,
									'show_signin'=> true,
								));
							}

							echo "</div>";
						}

					?>
				</div>
			</div>
			<?php

			return ob_get_clean();
		}

		public function event_manager_delete_btn($html, $EVENT){

			if(empty($html)) return $html;
			
			// get tickets sold
			$wc_ticket_product_id = $EVENT->get_prop('tx_woocommerce_product_id');

			if($wc_ticket_product_id){
				$sold = get_post_meta( $wc_ticket_product_id, 'total_sales',true);
				
				if($sold>0) return "<a class='fa fa-trash deleteEvent disa' data-s='disable' title='". evo_lang('Cannot delete because there are sales on this event') ."'></a>";
			}

			return $html;
		}

	// language
		function language($array){
			$newarray = array(
				array('label'=>'Ticket Fields','type'=>'subheader'),
					array('label'=>'Ticket Information','var'=>'1'),		
					array('label'=>'Ticket Sales On','var'=>'1'),		
					array('label'=>'View Ticket Stats','var'=>'1'),		
					array('label'=>'Sell tickets for this event','var'=>'1'),		
					array('label'=>'Ticket Price','var'=>'1'),		
					array('label'=>'Ticket Sales Price','var'=>'1'),		
					array('label'=>'Enable this to only allow one ticket per person','var'=>1),		
					array('label'=>'Sold Individually','var'=>1),		
					array('label'=>'Manage Ticket Stock'),		
					array('label'=>'This is how many tickets you have currently in stock.'),		
					array('label'=>'Ticket Section Subtitle'),		
					array('label'=>'This text will appear right under the ticket section title in eventcard'),		
					array('label'=>'SKU','var'=>'1'),		
					array('label'=>'Ticket Stock Capacity','var'=>'1'),		
					array('label'=>'Event Ticket Information & Stats','var'=>'1'),				
					array('label'=>'Price','var'=>'1'),				
					array('label'=>'Tickets in stock','var'=>'1'),				
					array('label'=>'Tickets Type','var'=>'1'),	
					array('label'=>'Simple','var'=>'1'),	
					array('label'=>'Variable','var'=>'1'),	
					array('label'=>'Tickets Information','var'=>'1'),	
					array('label'=>'Stock Status','var'=>'1'),				
					array('label'=>'Allow customers to submit inquiries.','var'=>'1'),				
					array('label'=>'Show remaining tickets','var'=>'1'),				
					array('label'=>'This will show remaining tickets for this event on front-end','var'=>'1'),				
					array('label'=>'Email Address to receive Inquiries','var'=>'1'),				
					array('label'=>'Subject for Inquiries Email','var'=>'1'),				
					array('label'=>'Show remaining count at','var'=>'1'),				
					array('label'=>'Show remaining count when remaining count go below this number.','var'=>'1'),				
					array('label'=>'Show guest list for event on eventCard','var'=>'1'),				
					array('label'=>'Attendees','var'=>'1'),				
					array('label'=>'Confirmed Attendance','var'=>'1'),				
					array('label'=>'This is a non-simple WC Ticket, must contact admin to make further edits!','var'=>'1'),	
					array('label'=>'Required'),			
					array('label'=>'Required'),			
					array('label'=>'Cannot delete because there are sales on this event','var'=>'1'),				
				array('type'=>'togend'),
			);
			return array_merge($array, $newarray);
		}
}
new evotx_actionuser();