<?php 
/** 
 * EVOVO Post Meta Boxes
 * @version 1.1.5
 */

class evovo_meta_boxes{
	public function __construct(){
		add_action('evotx_event_metabox_end',array($this, 'event_tickets_metabox'), 10, 5);
		add_filter('evotx_save_eventedit_page',array($this, 'event_ticket_save'), 10, 1);
		add_filter('evotx_after_saving_ticket_data',array($this, 'after_main_save'), 10, 1);
	}

	function event_tickets_metabox($eventid, $epmv, $wooproduct_id, $product_type, $EVENT){
		
		$show_metabox_content = true;

		// not for simple wc products
		if( $product_type != 'simple') $show_metabox_content = false;

		// check if wc product exists for this event
		if( empty($wooproduct_id)) $show_metabox_content = __('Woocommerce product not associated with this event!','evovo');

		// disable for repeating events
		if( $EVENT->is_repeating_event() ) $show_metabox_content = __('Variation options are not available for repeating events!','evovo');

		$show_metabox_content = apply_filters('evovo_before_tickets_meta_box', $show_metabox_content, $EVENT);

		echo "<div class='evopad10 evo_borderb'>";
		

		// if good to show the metabox content
		if(  $show_metabox_content === true ):
			$__woo_currencySYM = get_woocommerce_currency_symbol();


			EVO()->elements->_print_settings_toggle_nester_start(array(
				'id'=>'_evovo_activate',
				'value'=>$EVENT->get_prop('_evovo_activate'),
				'value_yn'=> $EVENT->check_yn('_evovo_activate'),
				'afterstatement'=>'evovo_section',			
				'tooltip'=>__('Create ticket variations and options for this event.','evovo'),
				'label'=> __('Enable Ticket Variations & Options','evovo'),
			));
			
				EVO()->elements->get_element(array(
					'type'=>'detailed_button', '_echo'=> true,
					'name'=>__('Variations & Options Settings','evovo'),
					'description'=>__('Configure Variations & Options for this Event','evovo'),
					'field_after_content'=> "Configure",
					'row_class'=>'evo_bordern evomar0',
					'trig_data'=> array(
						'uid'=>'evovo_settings',
						'lb_class' =>'evovo_lightbox',
						'lb_title'=>__('Variations & Options Settings','evovo'),	
						'ajax_data'=>array(					
							'event_id'=> $EVENT->ID,
							'wcid'=> $wooproduct_id,
							'a'=> 'evovo_get_settings',
						),
					),
				));
			
					
			EVO()->elements->_print_settings_toggle_nester_close();

		else:
			?>
			<p><i><?php echo  $show_metabox_content != false? $show_metabox_content: __('NOTE: Ticket variations and options are not available based on other activated ticket options!', 'evovo'); ?></i></p>			
			<?php
		endif;

		echo "</div>";

	}

	// get time format
		function get_time_format(){
			$wp_time_format = get_option('time_format');
			return (strpos($wp_time_format, 'H')!==false || strpos($wp_time_format, 'G')!==false)? 'H:i':'h:i:A';
		}

	// save fields
		function event_ticket_save($array){
			$array[] = '_evovo_activate';
			return $array;
		}
		// save block capacities to sync with ticket data
		function after_main_save($event_id){
			
			if(!isset($_POST['tx_woocommerce_product_id'])) return false;

			$wcid = (int)$_POST['tx_woocommerce_product_id'];
			 
			
		}
}
new evovo_meta_boxes();