<?php 
/**
 * Front of Woocommerce contnet
 * @version 1.2.9
 * 
 */

class EVOST_WC_Front{

	public function __construct()
	{
		add_filter('evotx_add_to_cart_evotxdata', array($this, 'evotx_data_adds'), 10, 2);

		add_filter('evotx_single_product_temp', array($this, 'frontend_temp'), 10,2);
		add_action('woocommerce_before_cart', array($this, 'before_cart'), 10);
		add_action('woocommerce_before_checkout_form', array($this, 'before_cart'), 10);
		
		add_action('evotix_confirmation_email_additional_data', array($this, 'tix_confirmation_email_data'), 10, 5);

		add_filter('evotx_get_attendees_for_event', array($this, 'seats_on_attendees'), 10, 2);
	}

	function evotx_data_adds($data, $event){
		if( !$event->check_yn('_enable_seat_chart')) return $data;

		$cal_shortcodes = EVO()->evo_generator->shortcode_args;

		$showmap = ((isset($cal_shortcodes['ux_val']) && $cal_shortcodes['ux_val'] == '3') || is_single())? 'true': 'false';
		$directadd = $event->check_yn('_allow_direct_add')? 'cart':'prev';

		$data['event_data']['showmap'] = $showmap;
		$data['event_data']['directadd'] = $directadd;
		return $data;
	}
	function before_cart(){

		$OPT = EVOST()->opt;
		$hide_cart_timer = !empty($OPT['_evost_hide_cart_exp']) && $OPT['_evost_hide_cart_exp']=='yes'? true: false;

		// if set to not show cart timer
		if($hide_cart_timer) return false;

		$items = WC()->cart->get_cart();
		if(!$items) return false;

		$cart_has_seat = false;
		$exp_time = 0;

		foreach($items as $cart_item_key=>$values){
			if(empty($values['evost_data'])) continue;
			if(isset($values['evost_data'])) $cart_has_seat = true;	

			$ST = new EVOST_Expirations($values['evotx_event_id_wc'], $values['product_id']);

			$exp_time = $ST->get_seat_expiration_time($values['evost_data']['seat_slug'], $cart_item_key);	
		}

		if(!$cart_has_seat) return false;

		$_exp_time = $exp_time - time();
		if($_exp_time<0) $_exp_time = 0;


		echo "<p class='evost_cart_timer' data-s='".$_exp_time."'>".evo_lang('Your seats will expire in').' <b>'. $ST->get_human_time( $_exp_time) .'</b></p>';
	}

	// front event card
	function frontend_temp($boolean, $event){

		// if seats are good to go 			
		if($event->check_yn('_enable_seat_chart')  && $event->get_prop('_evost_sections') && !$event->is_repeating_event()){	

			$seats = new EVOST_Expirations($event->ID, $event->wcid);
							
			ob_start();
			do_action('evost_front_before_seat_map', $seats);
			
			$class = apply_filters('evost_front_seat_map_class','evost_seat_map_section' ,$seats);

			// if show seats as lightbox
			$seats->load_seatmap_settings();
			$LB = $seats->get_seatmap_settings_prop('lightbox_map');
			
			if( $LB == 'yes'):

				echo "<p class=''>";					

				echo "<span class='evcal_btn evost_show_lightbox_seats marb10'>". evo_lang('Find Seats') ."</span></p>";

				$class .= ' evost_lb_on';
			else:

			?>
			<div class="<?php echo $class;?>">
				<?php echo EVOST()->frontend->print_init_html_content();?>
			</div>
			<?php
			endif;

			//print_r( get_option('_evost_expiration') );

			return ob_get_clean();
		}

		return $boolean;

	}

	// Show seat number information for confirmation ticket email
	public function tix_confirmation_email_data($TIX, $EVENT,$styles, $ticket_number, $tix_holder_index){

		// check if seat number is present in evo-tix
		if( $TIX->get_prop('Seat-Number') ):

			$evotx_tix = new evotx_tix();
			$product_id = $evotx_tix->get_product_id_by_ticketnumber($ticket_number);

			// get Seat slug
				$seat_slug = $TIX->get_prop('_evost_seat_slug');
				if( !$seat_slug ) $seat_slug = $TIX->get_prop('seat_id') ? $TIX->get_prop('seat_id') : false;

			// if no seat slug 
			if(!$seat_slug) return false;


			$ST = new EVOST_Seats_Seat($EVENT->ID,$product_id, $seat_slug );

			$sections = $EVENT->get_meta('_evost_sections', true);
			$readable_seat = $ST->get_readable_seat_number();

			// validate readable seat data
			$additions = '';
			if(!empty($readable_seat['section']) && !empty($readable_seat['seat'])){
				$additions = ' - '. 
					evo_lang('Section') . ': '. $readable_seat['section'] . (!empty($readable_seat['section_name'])? ' ('.$readable_seat['section_name'].')':'') .' | '. 
					evo_lang('Row') .': '. $readable_seat['row'] .' | '.
					evo_lang('Seat') .': '. $readable_seat['seat'];
			}

			// append data
			$readable_seat_info = $TIX->get_prop('Seat-Number'). $additions;
		?>
		
		<div>
			<p style="<?php echo esc_html( $styles['005'].$styles['pb5'].$styles['pt10'] );?>"><?php echo $readable_seat_info;?></p>
			<p style="<?php echo esc_html( $styles['004'].$styles['pb5'] );?>"><?php echo evo_lang( 'Seat Information');?></p>
		</div>
	
		<?php endif;
	}

	// show seat information on attendee information
	function seats_on_attendees($array, $event_id){
		if(!isset($array['id'])) return $array;
		$evo_tix_id = $array['id'];

		$seat_num = get_post_meta($evo_tix_id, 'Seat-Number',true);
		if( !$seat_num) return $array;

		$seat_slug = get_post_meta( $evo_tix_id , '_evost_seat_slug' , true );

		$array['oD']['seat_type'] = EVOST()->frontend->get_seat_type( $seat_slug , true);
		$array['oD']['seat_number'] = $seat_num;
		$array['oDD']['seat_slug'] = $seat_slug;

		return $array;
	}


} 