<?php
/**
 * Event seats tickets addon integration
 *
 * @author 		AJDE
 * @category 	Admin
 * @package 	EVOST/classes
 * @version     1.2.4
 */
class evost_tickets{
	
	function __construct(){

		include_once('class-integration-wc_front.php');
		include_once('class-integration-wc_block.php');
		new EVOST_WC_Front();
		//new EVOST_WC_Block();
		
		
		// adding to cart AJAX
		add_filter('evotx_add_ticket_to_cart_before', array($this, 'before_adding_to_cart'), 10, 3);
		add_filter('evotx_add_cart_item_meta', array($this, 'adding_to_cart'), 10, 4);
		add_filter('evotx_ticket_added_cart_ajax_data', array($this, 'ajax_return'), 10, 3);
		add_filter('woocommerce_get_cart_item_from_session', [$this, 'get_cart_item_meta_values'], 1, 3);
		
		add_action('evotx_after_ticket_added_to_cart', array($this, 'after_added'), 10, 3);
		add_action('evotx_cart_tickets_updated', array($this, 'cart_seats_updated'), 10, 2);

		// Cart view		
		add_action('evotix_cart_item_validation', array($this, 'cart_validation'), 10, 3);
		add_filter('evotx_ticket_item_meta_data', array($this, 'WC_cart_item_data'), 10, 3);
		add_action('evotx_cart_item_before_total', array($this, 'WC_before_total'), 10, 3);

		// quantity
		add_filter('evotx_cart_item_quantity',array($this,'cart_item_quantity'),1,4);
		add_filter('evotx_cart_item_max_qty', array($this, 'WC_cart_item_maxqty'), 10, 3);
		
		// checkout
		add_action('evotx_cart_ticket_removed',array($this,'update_removed_cart_items'),1,2);
		add_filter('evotx_checkout_addnames_other_vars', array( $this, 'add_ticket_infor_adds'),10,3);

		
		add_action('evotx_checkout_create_order_line_item',array($this,'order_item_meta_update_new'),1,4);
		add_filter('evotx_adjust_orderitem_ticket_stockother', array($this, 'adjust_ticket_item_stock'), 10, 7);
		add_filter('evotx_order_item_meta_slug_replace', array($this, 'ticket_meta_slug_replace'),10,1);
		add_filter('evotx_tix_save_field_meta', array( $this, 'tix_meta_values'),10,2);

		// hidden meta fields from backend
		add_filter('evotx_hidden_order_itemmeta', array($this,'hide_order_item_metafields'),10,1);

		// admin view
		add_filter('evotx_tixpost_data', array($this, 'admin_evotxpost_data'), 10, 3);

		
	}



	// CART
		// verify before adding to cart
		// wether seat is available for sale
			function before_adding_to_cart($boolean, $EVENT, $DATA){
				if( !isset($DATA)) return $boolean;
				if( !isset($DATA['other_data'])) return $boolean;
				if( !isset($DATA['other_data']['seat_slug'])) return $boolean;

				$SEATS = new EVOST_Seats_Seat($EVENT, $EVENT->wcid, $DATA['other_data']['seat_slug']);

				if(!$SEATS->is_seat_available(1)){
					$output['status'] = 'bad';				
					$output['msg'] = 'Seat not available at the moment';
					return json_encode($output); 
				}
				return $boolean;
			}

		// adding seat data to cart
			public function get_cart_item_meta_values($session_data, $values, $key) {
				if (!isset($session_data['evost_data'])) return $session_data;
		        if (!isset($session_data['evotx_event_id_wc'])) return $session_data;
		        if (!isset($session_data['evost_data']['seat_slug'])) return $session_data;

		        $custom_price = isset($session_data['evost_data']['seat_price']) ? floatval($session_data['evost_data']['seat_price']) : $session_data['data']->get_price();

   				// Set the cart item price to the custom price
   				$session_data['data']->set_price($custom_price);
   				$session_data['data']->set_regular_price($custom_price);
    			$session_data['data']->set_sale_price($custom_price);

		        return $session_data;
		    }
			function adding_to_cart($cart_item_data, $EVENT, $def_price, $DATA){
				if( !isset($DATA)) return $cart_item_data;
				if( !isset($DATA['other_data'])) return $cart_item_data;	
				if( !isset($DATA['other_data']['seat_slug'])) return $cart_item_data;

				$cart_item_data['evost_data']['seat_slug'] = $DATA['other_data']['seat_slug'];
				$cart_item_data['evost_data']['seat_number'] = $DATA['other_data']['seat_number'];
				$cart_item_data['evost_data']['seat_type'] = $DATA['other_data']['seat_type'];
				

				$SEATS = new EVOST_Seats_Seat($EVENT, $EVENT->wcid, $DATA['other_data']['seat_slug']);	
    			$custom_price = $SEATS->get_price();

				// custom seat price pass into cart item data
				$cart_item_data['_evost_seat_price'] = $cart_item_data['evost_data']['seat_price'] = $SEATS->get_price();

				// set seat expiration time
				$cart_item_data['evost_data']['seat_time'] = current_time('timestamp');

				return $cart_item_data;
			}
			
		// ajax after addin to cart 
			function ajax_return($ajaxdata, $EVENT, $DATA){
				if( !isset($DATA)) return $ajaxdata;
				if( !isset($DATA['other_data'])) return $ajaxdata;
				if( !isset($DATA['other_data']['seat_slug'])) return $ajaxdata;

				$SEATS = new EVOST_Seats_Json($EVENT, $EVENT->wcid);
				
				$ajaxdata['j'] = $SEATS->__j_get_all_sections();			
				$ajaxdata['j_cart'] = $SEATS->_get_cart_seats_for_events();				

				return $ajaxdata;
			}
		// after added to cart
			function after_added($cart_item_key, $EVENT, $DATA){
				if( !isset($DATA)) return false;
				if( !isset($DATA['other_data'])) return false;
				if( !isset($DATA['other_data']['seat_slug'])) return false;

				$SEATS = new EVOST_Seats_Seat($EVENT, $EVENT->wcid, $DATA['other_data']['seat_slug']);

				// put seat on temp hold while the seat is in cart
				// also set expiration time in unix
				$SEATS->add_seat_temphold( $cart_item_key, $DATA['qty'], $SEATS->seat_slug);	

				// multiple seats adding to cart for unaseats
				$seat_type = $SEATS->_get_seat_type_by_slug( $SEATS->seat_slug );

				if($seat_type != 'seat'){
					// if seat qty was updated make those changes in expirations
					$SEATS->nonseat_set_cart_expirations( 
						$cart_item_key, $SEATS->seat_slug, $DATA['cart_qty'], $seat_type);						
				}

				// update expirations for all existsing seats in cart
				$SEATS->reset_all_cart_seat_expirations();
			}

		// if seat updated
			function cart_seats_updated($cart_item_key, $cart_item){
				if(!isset($cart_item['evost_data'])) return;
				if(!isset($cart_item['evost_data']['seat_type']) && !isset($cart_item['evost_data']['seat_slug'])) return;

				$SEAT = new EVOST_Seats_Seat($cart_item['evotx_event_id_wc'], $cart_item['product_id'], $cart_item['evost_data']['seat_slug']);

				$SEAT->_get_seat_type_by_slug($cart_item['evost_data']['seat_slug']); 
				if($SEAT->seat_type == 'seat') return; // skip regular seats
				
				// update qty with unaseat values
				$SEAT->nonseat_match_cart_qty($cart_item_key, $cart_item['evost_data']['seat_slug'],$cart_item['quantity'], $SEAT->seat_type);

				// update expirations qty
				$SEAT->nonseat_set_cart_expirations(
					$cart_item_key, $cart_item['evost_data']['seat_slug'],$cart_item['quantity'], $SEAT->seat_type);

			}
		

	// CART VIEW
		function WC_cart_item_maxqty( $max, $product, $cart_item){
			if(!isset($cart_item['evost_data'])) return $max;
	   		if(empty($cart_item['_evost_seat_price']) ) return $max;

	   		$seat_slug = $cart_item['evost_data']['seat_slug'];	   		
	   		$SEAT = new EVOST_Seats_Seat( $cart_item['evotx_event_id_wc'], $cart_item['product_id'], $seat_slug);

	   		return $SEAT->get_max_capacity();
		}

		// SC 
		function cart_item_quantity($boolean, $product, $cart_item_key, $cart_item ){
			if(!isset($cart_item['evost_data'])) return $boolean;
	   		if(empty($cart_item['_evost_seat_price']) ) return $boolean;

	   		$seat_slug = $cart_item['evost_data']['seat_slug'];
	   		
	   		$SEAT = new EVOST_Seats_Seat( $cart_item['evotx_event_id_wc'], $cart_item['product_id'], $seat_slug);
	   		//$SEAT->_get_seat_type_by_slug( $seat_slug ); 

	   		$product_quantity = woocommerce_quantity_input( array(
				'input_name'  => "cart[{$cart_item_key}][qty]",
				'input_value' => $cart_item['quantity'],
				'max_value'   => $SEAT->get_max_capacity(),
				'min_value'   => '0',
			), '', false );

			return $product_quantity;   		
	   	}

	   	// validate cart seats, for each cart item
	   	function cart_validation($cart_item_key, $cart_item, $event_id){
	   		if(!isset($cart_item['evost_data'])) return false;
			if(!isset($cart_item['evost_data']['seat_slug']) ) return false;

			$seat_slug = $cart_item['evost_data']['seat_slug'];
			$SEAT = new EVOST_Seats_Seat( $event_id, $cart_item['product_id'], $seat_slug);
				
			// if seat not available or ticket sale is not active
			$stock_available = $SEAT->is_seat_available(  $cart_item['quantity']);
			if( !$stock_available){
				WC()->cart->remove_cart_item($cart_item_key);
				wc_add_notice( 'Ticket removed from cart, seat no longer available for sale!', 'error' );
			}

			// check if seat time has expired
			$seat_expired =  $SEAT->has_seat_expired($cart_item_key,  $seat_slug);
			if($seat_expired){
				// restock the seat				
				WC()->cart->remove_cart_item($cart_item_key);
				wc_add_notice( 'Ticket removed from cart due to seat expiration time!', 'error' );
				$SEAT->restock_temphold_seat($cart_item_key, $cart_item['quantity'], $seat_slug);
			}else{
				// reset timer
				$SEAT->reset_expiration_time_from_cart($cart_item_key,$seat_slug, $cart_item['quantity']);
			}		
		}

		// cart item data
		public function WC_cart_item_data($items, $cart_item, $EVENT){
			//print_r($cart_item['evost_data']);
			if (!isset($cart_item['evost_data'])) return $items;

			$cart_item_key = $cart_item['key'];
			$wcid = $cart_item[ 'product_id' ];
			$evost_data = $cart_item['evost_data'];
			$seat_type = isset($evost_data['seat_type']) ? $evost_data['seat_type']: false;
			if( !$seat_type ) return $items;

			$TXHelp = new evotx_helper();

			// seat data
				if( $seat_type == 'booseat'):
					$items['type'] = array( evo_lang('Seat Type') , evo_lang('Booth Seating'));
					$items['section'] = array( evo_lang('Booth') , $evost_data['seat_slug']);
				endif;
				if( $seat_type == 'unaseat'):
					$items['type'] = array( evo_lang('Seat Type') , evo_lang('Unassigned Seating'));
					$items['section'] = array( evo_lang('Unassigned Seat Section ID') , $evost_data['seat_slug']);
				endif;
				if( $seat_type == 'seat'):
					$SEAT = new EVOST_Seats($EVENT);
					$seat_data = $SEAT->get_readable_seat_data_by_slug( $evost_data['seat_slug'] );

					$items['section'] = array( evo_lang('Section') , $seat_data['section']);
					$items['row'] = array( evo_lang('Row') , $seat_data['row']);
					$items['seat'] = array( evo_lang('Seat') , $seat_data['seat']);
				endif;

			// seat time
			if( isset( $evost_data['seat_time'])){

				$ST = new EVOST_Expirations( $EVENT , $wcid );
				$exp_time = $ST->get_seat_expiration_time( $evost_data['seat_slug'], $cart_item_key);	

				//$_exp_time = $exp_time - time();
				//if($_exp_time<0) $_exp_time = 0;

				$items['time'] = array( 't' ,  'evost_cartitem_time_'. $exp_time  );
			}
				
			
			return $items;
		}

		// before total calculation
			function WC_before_total($EVENT, $cart_item, $cart){

				if( isset($cart_item['evost_data']) && isset($cart_item['_evost_seat_price'])){
					$cart_item['data']->set_price( $cart_item['_evost_seat_price'] );
				}
			}


	// CHECKOUT
		// add custom data as meta data to order item, when order is processed	    
			function order_item_meta_update_new($item, $cart_item_key, $values, $order){
				if(!isset($values['evost_data'])) return false;

				$seat_slug = $values['evost_data']['seat_slug'];
				$SEAT = new EVOST_Seats_Seat( $values['evotx_event_id_wc'], $values['product_id'], $seat_slug);

				// save seat type for oreder item meta
				$item->add_meta_data('_seat_type', $SEAT->seat_type ,true);

				if(isset($values['evost_data']['seat_number']) ){	  
					// convert to a proper seat number
					$item->add_meta_data('Seat-Number', $values['evost_data']['seat_number'] ,true);
		        }		
		        if(isset($values['evost_data']['seat_slug']) )
		        	$item->add_meta_data('_evost_seat_slug', $values['evost_data']['seat_slug'],true);

			}

		// If item removed from cart
			function update_removed_cart_items($cart_item_key, $cart_session_data){	
		        if (!isset($cart_session_data['evost_data']) || !isset($cart_session_data['wcid']) || !isset($cart_session_data['evost_data']['seat_slug'])) return;

				$seat_slug = $cart_session_data['evost_data']['seat_slug'];
				$SEAT = new EVOST_Seats_Seat($cart_session_data['evotx_event_id_wc'], $cart_session_data['wcid'], $seat_slug);
				$SEAT->restock_temphold_seat($cart_item_key, $cart_session_data['quantity'], $seat_slug);  
		    }
		// additional ticket information at the checkout additions from VO
			function add_ticket_infor_adds( $O, $V, $EVENT){
				
				if (!isset($V['evost_data']) || !isset($V['evost_data']['seat_number'])) return $O;
				$O .= "<span style='display:block'><b>" . evo_lang('Seat Number') . ':</b> ' . esc_html($V['evost_data']['seat_number']) . "</span>";
				return $O;
			}

		// For each seat in the order
		// Adjust seat stock during checkout and for other order statuses eg. cancel order, completed order etc.
		function adjust_ticket_item_stock($boolean, $TIX_EVENT, $order, $item_id, $item, $type, $stage){
			
    		$seat_slug = wc_get_order_item_meta($item_id ,'_evost_seat_slug'); 
    		if(!$seat_slug) return $boolean;

    		$SEAT = new EVOST_Seats_Seat($TIX_EVENT, $item['product_id'], $seat_slug);
    		$SEAT->delete_seat_expiration($seat_slug);

    		if($SEAT->seat_type == 'seat'){
    			$SEAT->adjust_stock($type); // make seat uva

    			// order notes
    			if($type == 'reduce'){

    				// checkout on the cart
    				if( $stage == 'cart'){
    					if($SEAT->is_seat_slug_exists()){
    						$order->update_status('pending','Seat already purchased by another customer');
    					}
    				}

	    			$order->add_order_note( sprintf( 
						__( 'Event: (%s) seat %s made unavailable.', 'woocommerce' ), 
						$TIX_EVENT->get_title(), $SEAT->get_seat_number()) 
	    			);
	    		// increase
	    		}else{
	    			$order->add_order_note( sprintf( 
						__( 'Event: (%s) seat %s made available.', 'woocommerce' ), 
						$TIX_EVENT->get_title(), $SEAT->get_seat_number()) );
	    		}
    			
    		}else{
    			// UNA is already reduced when added to cart
    			// if restock then 
    			if($type != 'reduce') 
    				$SEAT->una_restock_seat($item['qty']); // restock 
    		}
    		
    		return $boolean;   			    	
		}

		function ticket_meta_slug_replace($array){
			$array['Seat-Number'] = evo_lang('Seat Number');
			$array['_seat_type'] = evo_lang('Seat Type');
			return $array;
		}

		// save ticket item meta custom values for faster retrieve of data
		// Save values for "evo-tix" CPT
		function tix_meta_values($array, $item){
			if(!empty($item['Seat-Number'])) $array['_seat_number'] = $item['Seat-Number'];
			if(!empty($item['Seat-Number'])) $array['Seat-Number'] = $item['Seat-Number']; // before v1.0
			if(!empty($item['_evost_seat_slug'])) $array['_evost_seat_slug'] = $item['_evost_seat_slug'];
			// seat slug is saved as "seat_id" in version < 1.0
			
			return $array;
		}

// ADMIN
	// evo-tix post ticket data addition
		public function admin_evotxpost_data($data_fields, $TIX_CPT, $EVENT){

			if ($stn = $TIX_CPT->get_prop('Seat-Number')) {
			$data_fields['evost_1'] = [__('Seat Number', 'evost'), $stn];
			$seat_slug = $TIX_CPT->get_prop('_evost_seat_slug');
			$product_id = $TIX_CPT->get_product_id_by_ticketnumber($seat_slug);
			$seat = new EVOST_Seats_Seat($EVENT->ID, $product_id, $seat_slug);
			$readable_seat = $seat->get_readable_seat_number();
			$data_fields['evost_2'] = [__('Seat Section', 'evost'), $readable_seat['section']];
			$data_fields['evost_3'] = [__('Seat Row', 'evost'), $readable_seat['row']];
			$data_fields['evost_4'] = [__('Seat ID', 'evost'), $seat_slug];
		}
		return $data_fields;
		}

// OTHER
	// order item meta fields that are hidden from view - admin order edit page
		function hide_order_item_metafields($array){
			$array[] = '_evost_seat_slug';
			//$array[] = '_seat_type';
			return $array;
		}


	

}
new evost_tickets();