<?php
/**
 * 	EventON Webhook integration
 *	@version 3.0.4
 */

class EVORS_Webhooks{
	public function __construct(){
		
		add_filter('evo_webhook_triggers', array($this, 'add_webhook_triggers'), 10, 1);
		add_filter('evo_webhooks_data', array($this, 'add_webhook_trigger_fields'), 10, 1);

		add_action('evors_new_rsvp_saved',array($this, 'new_rsvp'), 10, 4);
		add_action('evors_checkin_guest',array($this, 'status_changed'), 10, 3);
	}

	function add_webhook_triggers($array){
		$array['new_rsvp'] = 'RSVP: When new RSVP is received';
		$array['rsvp_status_changed'] = 'RSVP: When guest checkin status changed';
		return $array;
	}

	function add_webhook_trigger_fields( $arr){
		$arr['new_rsvp'] = implode(', ', $this->get_fields('new_rsvp'));
		$arr['rsvp_status_changed'] = implode(', ', $this->get_fields('rsvp_status_changed'));
		return $arr;
	}

	function get_fields( $type = 'new_rsvp'){
		$fields = array(
			'type','new_rsvp_id','rsvp_status','first_name','last_name','email',
			'count','event_id','event_name', '+ Additional fields'
		);

		if( $type == 'rsvp_status_changed'){
			unset($fields[8]);
			unset($fields[9]);
		}

		return $fields;
	}

	function new_rsvp($created_rsvp_id, $args, $RR, $CLASS){

		if( $webhookurl = EVO()->webhooks->is_hook_active('new_rsvp' )){

			$fields = array(
				'type'=>'new_rsvp',
				'new_rsvp_id'=> $created_rsvp_id,
				'rsvp_status'=> $RR->get_rsvp_status(),
				'first_name'=> $RR->first_name(),
				'last_name'=> $RR->last_name(),
				'email'=> $RR->email(),
				'phone'=> $RR->get_prop('phone'),
				'count'=> $RR->count(),
				'event_id'=> $RR->event_id(),
				'event_name' 	=> 	$CLASS->event->get_title()
			);

			// combine with additional data
			$add_data = $this->get_additional_fields( $CLASS , $RR );
			
			if( count($add_data)> 0) $fields = array_merge($fields, $add_data);

			EVO()->webhooks->send_webhook( $webhookurl, $fields );
		}
	}

	function status_changed($ID, $status, $RR){
		if( $webhookurl = EVO()->webhooks->is_hook_active('rsvp_status_changed' )){
			EVO()->webhooks->send_webhook( $webhookurl, array(
				'type'=>'rsvp_status_changed',
				'rsvp_id'=> $ID,
				'rsvp_status'=> $RR->get_rsvp_status(),
				'first_name'=> $RR->first_name(),
				'last_name'=> $RR->last_name(),
				'email'=> $RR->email(),
				'phone'=> $RR->get_prop('phone'),
				'count'=> $RR->count(),
				'event_id'=> $RR->event_id(),
			));
		}
	}

	private function get_additional_fields( $CLASS , $RR ){
		$data = array();

		EVO()->cal->set_cur('evcal_rs');

		// Additional fields
			if(!$CLASS->_show_none_AF()){
				for($x=1; $x<= EVORS()->frontend->addFields; $x++){

					// field validation
					if( !EVO()->cal->get_prop('evors_addf'.$x)) continue;
					if( !EVO()->cal->get_prop('evors_addf'.$x.'_1')) continue;
					if(!$CLASS->_can_show_AF('AF'.$x)) continue;
					
					$data['evors_addf'.$x.'_name'] = EVO()->cal->get_prop('evors_addf'.$x.'_1');
					$data['evors_addf'.$x] = $RR->get_prop('evors_addf'.$x);
				}
			}

		return $data;

	}
}