<?php 
/**
 * RSVP Event Post meta boxes
 * @version 3.0.6
 */

$help = new evo_helper();
$EVENT = new EVORS_Event( $EVENT );
$settings = new EVO_Settings();
$event_id = $EVENT->event->ID;

// Before event RSVP plug
do_action('evors_admin_rsvp_event_options_before', $EVENT);

$evors_rsvp = $EVENT->event->get_prop('evors_rsvp');
$evors_show_rsvp = $EVENT->event->get_prop('evors_show_rsvp');
$evors_show_whos_coming = $EVENT->event->get_prop('evors_show_whos_coming');
$evors_add_emails = $EVENT->event->get_prop('evors_add_emails');

?>
<div class='evors evo_metabox eventon_mb'>
	<?php 
	$settings->print_event_edit_box_yn_header(array(
		'id'=>'evors_rsvp',
		'value'=> $EVENT->event->get_prop('evors_rsvp'),
		'afterstatement' => 'evors_details',
		'name'=> __('Activate RSVP for this Event','evors'),
		'tooltip'=> __('Allow visitors to RSVP to this event by enabling RSVP for this event.','evors'),
		'reload_id'=> 'evors',
		'eid'=> $event_id
	));
	?>
	<div id='evors_details' class='evors_details evomb_body evo_bordert' <?php echo ( $evors_rsvp=='yes')? null:'style="display:none"'; ?>>		
		<div class="evors_stats evodfx evofxdrr evofxjcse evopadt20">
		    <?php
		    // Initial values
		    $synced = $EVENT->total_rsvp_counts();
		    $evors_capacity_count = $EVENT->event->get_prop('evors_capacity_count');

		    // Define RSVP statuses
		    $statuses = array(
		        'y' => __('YES', 'evors'),
		        'n' => __('No', 'evors'),
		        'm' => __('Maybe', 'evors')
		    );

		    // Loop through statuses to generate HTML
		    foreach ($statuses as $key => $label) {
		        ?>
		        <p class='evors_stats_item <?php echo $key; ?> evofx_100 evodfx evofxjcc evofxaic' data-type='<?php echo esc_attr( $key );?>'>
		            <b class='evofz42 evofw700 evomarr10 evoff_1'><?php echo $synced[$key]; ?></b>
		            <span class='evobr5 evottu evopad5-15 evofz12 evomart10 evofwb'><?php echo $label; ?></span>
		        </p>
		        <?php
		    }

		    do_action('evors_admin_eventedit_stats_end', $EVENT);
		    ?>
		</div>
		
		<?php 
		// stat bar
			if($evors_capacity_count):?>
				<div class='evors_stats_bar'>
					<p><span class='yes' style='width:<?php echo (int)(($synced['y']/$evors_capacity_count)*100);?>%'></span><span class='maybe' style='width:<?php echo (int)(($synced['m']/$evors_capacity_count)*100);?>%'></span><span class='no' style='width:<?php echo (int)(($synced['n']/$evors_capacity_count)*100);?>%'></span></p>
				</div>
				<?php do_action('evors_admin_eventedit_statbar_end',$EVENT, $synced, $evors_capacity_count );?>
		<?php endif;?>
		
		<div class='evo_borderb evopad20'>
			<?php
				EVO()->elements->get_element(array(
					'type'=>'detailed_button', '_echo'=> true,
					'name'=>__('RSVP Settings','evors'),
					'description'=>__('Configure event RSVP settings','evors'),
					'field_after_content'=> "Configure",
					'row_class'=>'evo_bordern evomar0',
					'trig_type'=> 'trig_lb',
					'trig_data'=> array(
						'uid'=>'evo_get_rsvp_settings',
						'lb_class' =>'config_rsvp_data',
						'lb_title'=> __('Configure Event RSVP Settings','evors'),	
						'ajax_data'=>array(
							'a'=>'evors_get_event_rsvp_settings',
							'eid'=>		$event_id,
						),
					),
				));
			?>
		</div>
		<div class=''>		
		<?php	


			// PLUGGABLE
			do_action('evors_admin_before_settings', $EVENT);
			do_action('evors_event_metafields', $EVENT, EVORS()->evors_opt );
		?>		
		</div>

		<div class='evopad20 '>
			<h4 class='evopadl10 evottu'><?php _e('Other RSVP Options','evors');?></h4>
			<?php

				EVO()->elements->get_element(array(
					'type'=>'detailed_button',
					'_echo'=> true,
					'name'=>__('View Attendees','evors'),
					'description'=>__('Detailed list of event attendees','evors'),
					'content'=> "<i class='fa fa-users'></i>",
					'trig_data'=> array(
						'uid'=>'evors_view_attendees',
						'lb_class' =>'evors_view_attendees',
						'lb_title'=>__('View Attendees','evors'),	
						'ajax_data'=>array(					
							'e_id'=> $event_id,
							'action'=>'the_ajax_evors_a1',
						),
					),
				));
				// DOWNLOAD CSV link 
					$exportURL = add_query_arg(array(
					    'action' => 'the_ajax_evors_f3',
					    'e_id' => $event_id,     // cache buster
					), admin_url('admin-ajax.php'));

				EVO()->elements->get_element(array(
					'type'=>'detailed_button',
					'_echo'=> true,
					'name'=>__('Download (CSV)','evors'),
					'description'=>__('Attendees data as CSV file','evors'),
					'link'=> $exportURL,
					'content'=>'<i class="fa fa-download"></i>',
				));

				EVO()->elements->get_element(array(
					'type'=>'detailed_button',
					'_echo'=> true,
					'name'=>__('Email Attendees','evors'),
					'description'=>__('Email various attendee types','evors'),
					'content'=> "<i class='fa fa-envelope'></i>",
					'trig_data'=> array(
						'uid'=>'evors_emailing',
						'lb_class' =>'evors_emailing',
						'lb_title'=>__('Email Attendees','evors'),	
						'ajax_data'=>array(					
							'e_id'=> $event_id,
							'action'=>'the_ajax_evors_a8',
						),
					),
				));

				EVO()->elements->get_element(array(
					'type'=>'detailed_button',
					'_echo'=> true,
					'name'=>__('Sync Count','evors'),
					'description'=>__('Sync the RSVP count with all current rsvp data','evors'),
					'content'=>'<i class="fa fa-undo"></i>',
					'trig_data'=> array(
						'uid'=>'evors_sync_attendees',
						'ajax_data'=>array(					
							'e_id'=> $event_id,
							'action'=>'the_ajax_evors_a2',
						),
					),
					'trig_type'=>'trig_ajax',
				));
				?>
		</div>
		
		<span id='evors_message' class='evopad20 evodb' style='display:none;background-color: var(--evo_color_second);'></span>
	</div>
</div>
<?php
