<?php
/**
 * Meta boxes for evo-rsvp
 *
 * @author 		AJDE
 * @category 	Admin
 * @package 	EventON/Admin/evo-rsvp
 * @version     3.0.6
 */

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class evors_meta_boxes{
	public $x;

	public function __construct(){
		add_action( 'add_meta_boxes', array($this, 'evoRS_meta_boxes') );
		add_action( 'eventon_save_meta', array($this, 'evoRS_save_meta_data'), 10 , 2 );
		add_action( 'save_post', array($this, 'evoRS_save_rsvp_meta_data'), 1 , 2 );

		add_filter('evo_eventedit_repeat_metabox_top', array($this, 'repeat_notice'), 10,1);

		// dynamic meta box content		
		add_filter('evo_eventedit_pageload_dom_ids', array($this, 'eventedit_dom_ids'), 12,4);
		add_filter('evo_eventedit_pageload_dom_data',array($this, 'eventedit_pageload_data'), 12, 4);
		add_filter('evo_eventedit_pageload_data', array($this, 'legacy_eventedit_content'), 12,4);

		// Debug reminders
		//$fnc = new evorm_fnc();
		//$result = $fnc->send_email(13, 'evorm_pre_1');

	}
	// Initiate
		function evoRS_meta_boxes(){
			add_meta_box('evors_mb1',__('RSVP Event','evors'), array($this, 'event_metabox_content'),'ajde_events', 'normal', 'high');
			add_meta_box('evors_mb1',__('RSVP Event','evors'), array($this, 'evoRS_metabox_rsvp'),'evo-rsvp', 'normal', 'high');
			add_meta_box('evors_mb3',__('RSVP Email','evors'), array($this, 'evoRS_notifications_box2'),'evo-rsvp', 'side', 'default');
			add_meta_box('evors_mb4',__('RSVP Notes','evors'), array($this, 'evors_notes'),'evo-rsvp', 'side', 'default');

			add_meta_box('evors_mb5',__('RSVP Webhooks','evors'), array($this, 'evors_webhooks'),'evo-rsvp', 'side', 'default');
			
			do_action('evoRS_add_meta_boxes'); // pluggable function
		}	

// RSVP Webhooks
	public function evors_webhooks(){
		
	}

// notices for repeat
	public function repeat_notice( $EVENT){
		if( $EVENT->check_yn('_manage_repeat_cap_rs') )
			echo "<p class='evopad10 evoclw evobr10 evomarb10i' style='background-color: #f76a6a;'>". __('IMPORTANT: RSVP Capacity for each repeating instances is enabled, changes made to repeating instances may effect the capacity and already RSVP-ed date for each repeat instance!','evotx') . "</p>";
	}
	
// RSVP Notes
	function evors_notes(){
		global $post;

		$RR = new EVO_RSVP_CPT($post->ID);

		$notes = $RR->get_notes();
		?><div class='evors_notes'><?php
		if(!$notes):
		?>
			<p><?php _e('There are no notes','evors');?></p>
		<?php
		else:

			$EVO_Help = new evo_helper();
			$now = current_time('timestamp');
			
			// notes must be in an array format
			if(is_array($notes)){

				//print_r($notes);
				
				rsort($notes); // reverse the order so recent notes show on top
				foreach($notes as $note){
					$author = isset($note['author']) && $note['author']!= 'na'? $note['author']: false;
					if($author){
						$A = get_user_by('ID',$author);
						$AN = 'by ' . $A->display_name;
					}else{
						$AN = '';
					}

					$timestamp = (int)$note['date'];
					$human_time = $EVO_Help->get_human_time( $now - $timestamp);
					?>
					<p>
						<span class='note evoposr evobr5'><?php echo $note['note'];?></span>
						<span class='date evofz12 evomart5 evodb evotar'><?php echo  $human_time . ' ' . __('ago','evors') . ' ' . $AN;?></span>
					</p>
					<?php
				}
			}
			
		endif;
		?></div><?php
	}

// notification email box
	function evoRS_notifications_box2(){
		global $post;

		$RR = new EVO_RSVP_CPT($post->ID);

		$__notification_to_email = (!empty(EVORS()->evors_opt['evors_notfiemailto']) )?
						htmlspecialchars_decode (EVORS()->evors_opt['evors_notfiemailto']):get_bloginfo('admin_email');

		?>
		
		<div class='evoRS_resend_conf'>
			<div class='evoRS_rc_in'>				
				<?php if($RR->get_rsvp_type()=='normal'):?>
					<p><i><?php echo sprintf(__('Re-send <b>Customer Confirmation</b> email again to %s.','evors'),$RR->email());?></i></p>
					<a class='evo_btn evors_resend_email' data-rsvpid='<?php echo $RR->ID;?>' data-t='confirmation'><?php _e('Re-send Email','evors');?></a> 
				<?php endif;?>

				<p><i><?php echo sprintf(__('Re-send <b>Admin Notification</b> email to %s.','evors'),$__notification_to_email);?></i></p>
				<a class='evo_btn evors_resend_email' data-rsvpid='<?php echo $RR->ID;?>' data-t='notification'><?php _e('Re-send Email','evors');?></a>
				<p class='message' style='display:none'><?php _e('Email resend action performed!','evors');?></p>
			</div>
		</div>
		
		<?php if($RR->get_rsvp_type()=='normal'):?>
		<div class='evoRS_resend_conf'>
			<div class='evoRS_rc_in'>
				<p><i><?php _e('Send RSVP Emails to other email addresses using below fields. <br/>NOTE: you can send to multiple email address separated by commas.','evors');?></i></p>
				<p class='field'><input type='text' placeholder='Comma separated email addresses' style="width:100%" /></p>
				<p class='field'>
					<select name='type'>
						<option value='confirmation'><?php _e('Confirmation Email','evors');?></option>
						<option value='notification'><?php _e('Admin Notification Email','evors');?></option>
					</select>
					</p>
				<a id='evoRS_custom_email' class='evo_btn' data-rsvpid='<?php echo $RR->ID;?>' data-empty='<?php _e('Email field can not be empty!','evors');?>' ><?php _e('Send Email','evors');?></a>
				<p class='message' style='display:none'><?php _e('Email send action performed!','evors');?></p>
			</div>
		</div>

		<div class='evomart20 evo_bordert'>

			<h4 class=''><?php _e('Preview RSVP Emails','evors');?></h4>

			<p class=''>
				<?php 

				EVO()->elements->print_trigger_element( array(
					'title'=> __('Confirmation Email'),
					'id'=>'evors_email_preview',
					'dom_element'=> 'span',
					'uid'=>'evors_email_preview',
					'lb_class' =>'evors_email_preview',
					'lb_padding'=>'evopad0',
					'lb_title'=> __('RSVP Confirmation Email Preview'),	
					'ajax_data'=>array(
						'a'=>'evors_email_preview',
						'evo_rsvp_id'=> $post->ID 
					),
				),'trig_lb');

				?>
				<?php echo EVO()->elements->tooltips('Preview how the RSVP email look like.','L');?>
			</p>
			<p class=''>
				<?php 

				EVO()->elements->print_trigger_element( array(
					'title'=> __('Admin Notification Email'),
					'id'=>'evors_email_preview',
					'dom_element'=> 'span',
					'uid'=>'evors_email_preview',
					'lb_class' =>'evors_email_preview',
					'lb_padding'=>'evopad0',
					'lb_title'=> __('Admin Notification Email Preview'),	
					'ajax_data'=>array(
						'a'=>'evors_email_preview',
						'email_type'=>'notification_email',
						'evo_rsvp_id'=> $post->ID 
					),
				),'trig_lb');

				?>
				<?php echo EVO()->elements->tooltips('Preview how the RSVP email look like.','L');?>
			</p>

		</div>

		<?php endif;?>
		<?php

		do_action('evors_rsvppost_confirmation_end',$RR );
	}

// META box for evo-rsvp post page
	function evoRS_metabox_rsvp(){
		global $post, $ajde, $pagenow;

		wp_enqueue_script('evcal_functions');
		
		$RR = new EVO_RSVP_CPT($post->ID);
		$RSVP = new EVORS_Event( $RR->event_id(), $RR->repeat_interval());
		
		$pmv = $RR->pmv;
		$optRS = EVORS()->evors_opt;
		
		//$what = $eventon_rs->frontend->send_email(array(
		//	'e_id'=>1335,
		//), 'digest');

		// Debug email templates
			if(isset($_GET['debug']) && $_GET['debug']):

				$email_type = isset($_REQUEST['type'])? $_REQUEST['type']: 'confirmation_email';
				$l = isset($_REQUEST['l'])? $_REQUEST['l']: ''; // template location
				$notice_type = isset($_REQUEST['notice_type'])? $_REQUEST['notice_type']: 'new_rsvp';
				$notice_data = isset($_REQUEST['notice_data'])? $_REQUEST['notice_data']: '';

				$tt = EVORS()->email->_get_email_body(
					apply_filters('evors_preview_email_arg', array(
						'e_id'=> $RR->event_id(),
						'rsvp_id'=> $post->ID,
						'notice_type'=> $notice_type, 
						'notice_title'=> evo_lang('Testing title'), 
						'notice_message'=> evo_lang('Testing notice message'),
						'notice_data'=>$notice_data,
						'password'=>'trgtrgtr'
					)), 
					$email_type,
					$l
				);
				echo $tt;

			endif;
		
		// get translated check-in status
			$checkin_status = EVORS()->frontend->get_checkin_status($RR->checkin_status());			
			wp_nonce_field( plugin_basename( __FILE__ ), 'evorsvp_nonce' );
		?>	
		<div class='eventon_mb' style='margin:-6px -12px -12px'>
		<div style='background-color:#ECECEC; padding:15px;'>
			<div style='background-color:#fff; border-radius:8px;'>

			<table id='evors_rsvp_tb' width='100%' class='evo_metatable'>	

			<?php
				$RSVP_status_array = EVORS()->rsvp_array_;
				$RSVP_status_array[''] = '-';

				$table_rows = array(
					'rsvp_id'=>array(
						'type'=>'normal',
						'name'=> __('RSVP #','evors'),
						'value'=>$post->ID
					),
					'rsvp'=>array(
						'type'=> 'select',
						'name'=> __('RSVP Status','evors'),
						'options'=> $RSVP_status_array,
					),
					'checkin_status'=>array(
						'type'=>'checkin_status',
					),
					'first_name'=>array(
						'type'=>'normal',
						'name'=> __('First Name','evors'),
						'required'=>true,
						'editable'=>true,
						'value'=> (!empty($pmv['first_name']) ? $pmv['first_name'][0]:'')
					),'last_name'=>array(
						'type'=>'normal',
						'name'=> __('Last Name','evors'),
						'required'=>true,
						'editable'=>true,
						'value'=> (!empty($pmv['last_name']) ? $pmv['last_name'][0]:'')
					),'email'=>array(
						'type'=>'normal',
						'name'=> __('Email Address','evors'),
						'required'=>true,
						'editable'=>true,
						'value'=> (!empty($pmv['email']) ? $pmv['email'][0]:'')
					),'count'=>array(
						'type'=>'normal',
						'name'=> __('Count','evors'),
						'editable'=>true,
						'value'=> (!empty($pmv['count']) ? $pmv['count'][0]:'')
					)
				);

				foreach($table_rows as $key=>$data){
					switch($data['type']){
						case 'normal':
							echo "<tr><td>". $data['name'] .":". (!empty($data['required']) && $data['required']? '*':'') ." </td><td>";
							if(!empty($data['editable']) && $data['editable']){
								echo "<input type='text' name='{$key}' value='".$data['value']."'/>";
							}else{
								echo $data['value'];
							}
							echo "</td></tr>";
						break;
						case 'select':
							?><tr><td><?php echo $data['name'];?>: </td>
							<td><select name='<?php echo $key;?>'>
							<?php 
								foreach($data['options'] as $rsvpOptions=>$rsvpV){
									echo "<option ".( (!empty($pmv[$key]) && $rsvpOptions==$pmv[$key][0])? 'selected="selected"':'')." value='{$rsvpOptions}'>{$rsvpV}</option>";
								}
							?>
							</select>
							</td></tr>
							<?php
						break;
						case 'checkin_status':

							?>
							<tr><td><?php _e('Checkin to Event Status','evors');?>: </td><td>
								<?php if( $RR->get_rsvp_status() == 'n'):?>
									<span class='rsvp_ch_st rsvp_n' ><?php evo_lang_e('Not Coming')?></span>
								<?php else:?>
									<span class='rsvp_ch_st evors_trig_checkin <?php echo $RR->checkin_status();?>' data-status='<?php echo $RR->checkin_status();?>' data-nonce="<?php echo wp_create_nonce(AJDE_EVCAL_BASENAME);?>" data-rsvp_id='<?php echo $post->ID;?>'><?php echo $checkin_status;?></span>
								<?php endif;?>

							<?php do_action('evors_admin_rsvp_cpt_checkinstatus',$RR);?>
							</td></tr>
							<?php 
						break;
					}
				}
			?>
				
				<tr><td><?php _e('Receive Email Updates','evors');?>: </td>
					<td><?php echo $ajde->wp_admin->html_yesnobtn(array(
						'id'=>'updates','input'=>true,
						'default'=>( $RR->get_updates() ? 'yes':'no' )
					));?></td></tr>
				<tr><td><?php _e('Event','evors');?>: </td>
					<td><?php 
						// event for rsvp
						if(empty($pmv['e_id'])){
							$events = get_posts(array('posts_per_page'=>-1, 'post_type'=>'ajde_events'));
							if($events && count($events)>0 ){
								echo "<select name='e_id'>";
								foreach($events as $event){
									echo "<option value='".$event->ID."'>".get_the_title($event->ID)."</option>";
								}
								echo "</select>";
							}
							wp_reset_postdata();
						}else{
							echo '<a href="'.get_edit_post_link($pmv['e_id'][0]).'">'.get_the_title($pmv['e_id'][0]).'</a></td></tr>';
						}

				// REPEATING interval
				if($pagenow!='post-new.php' && !empty($pmv['e_id'])){

					$saved_ri = (!empty($pmv['repeat_interval']) && $pmv['repeat_interval'][0]!='0')?
						$pmv['repeat_interval'][0]:'0';
					$event_pmv = get_post_custom($pmv['e_id'][0]);
					$datetime = new evo_datetime();
					?>
					<tr><td><?php _e('Event Date','evors');?>: </td>
					<td>
					<?php 
					$repeatIntervals = (!empty($event_pmv['repeat_intervals'])? unserialize($event_pmv['repeat_intervals'][0]): false);

					// If the event has repeating instances
					if($repeatIntervals && count($repeatIntervals)>0){
								
						echo "<select name='repeat_interval'>";
						$x=0;
						$wp_date_format = get_option('date_format');
						foreach($repeatIntervals as $interval){
							$time = $datetime->get_int_correct_event_time($event_pmv,$x);
							echo "<option value='".$x."' ".( $saved_ri == $x?'selected="selected"':'').">".date($wp_date_format.' h:i:a',$time)."</option>"; $x++;
						}
						echo "</select>";
					}else{
					// not a repeating event
						echo $RSVP->event->get_formatted_smart_time();
					}
					?></td></tr>
					<?php
				}


				$form_fields = EVORS()->rsvpform->get_form_fields($RSVP, $RR);


				foreach($form_fields as $key=> $fdata){
					extract( $fdata );
					$FIELDVAL = $RR && $RR->get_prop($key) ? $RR->get_prop($key) :'-';

					echo "<tr>";

					switch ($type) {
						case 'text':
							$field_value = is_array( $FIELDVAL ) ? implode(',', $FIELDVAL) : $FIELDVAL;
							
							echo "<td>".$name."</td>
							<td><input type='text' name='{$key}' value='".$field_value."'/></td>";
							break;	
						case 'checkbox':
							echo "<td>". html_entity_decode($name) ."</td>
							<td>";

							echo $ajde->wp_admin->html_yesnobtn(array(
								'id'=>$key,
								'input'=>true,
								'default'=> $FIELDVAL
							));
							echo "</td>";
							break;	
						case 'html':
							echo "<td>".html_entity_decode($name)."</td>
							<td>".$FIELDVAL."</td>";
							break;	
						case 'textarea':
							echo "<td>".$name."</td>
							<td><textarea style='width:100%' name='evors_addf".$x."_1'>".$FIELDVAL."</textarea></td>";
							break;
						case 'dropdown':
							
							echo "<td>".$name."</td>
							<td><select name='evors_addf{$x}_1'>";	

								// if no value was submitted for the select field
								if( $FIELDVAL == '-'  ) echo "<option value='-'>-</option>";							
								foreach($options as $slug=>$option ){
									
									$selected = $FIELDVAL == $slug ? 'selected="selected"' :'';
									echo "<option ". $selected." value='{$slug}'>{$option}</option>";
								}
							echo "</select></td>";
							break;
						case 'file':
							echo "<td>".$name."</td><td>";

							if( $FIELDVAL != '-'){
								$url = wp_get_attachment_url( $FIELDVAL );
								if($url) $FIELDVAL = $url;
							}

							echo $FIELDVAL . "</td>";						
							
							break;
					}

					if( has_action("evors_additional_field_{$type}") ):
						do_action("evors_additional_field_{$type}", $FIELDVAL, $name, $required);
					endif;

					echo "</tr>";
				}


				
				// additional guest names\
					//print_r($pmv['names']);
					$names = !empty($pmv['names']) && isset($pmv['names'][0]) ? 
						maybe_unserialize($pmv['names'][0]): false;
					if($names && is_array($names)){
						echo "<tr><td>".__('Other Attendee Names','evors').": </td><td>";
						foreach($names as $name){
							echo "<p>".$name . "</p>";
						}
						echo "</td></tr>";
					}
				?>
				
				<tr><td><?php _e('Additional Notes','evors');?>: </td>
					<td><textarea style='width:100%' type='text' name='additional_notes'><?php echo $RR && $RR->get_prop('additional_notes') ? $RR->get_prop('additional_notes') :'';?></textarea></td></tr>

				<?php
				// plugabble hook
				if( $RR->event_id() )	
					do_action('eventonrs_rsvp_post_table',$RR->ID, $pmv, $RR);
				?>
			</table>
			</div>
		</div>
		</div>
		<?php
	}

// SAVE values for evo-rsvp post 
	function evoRS_save_rsvp_meta_data($post_id, $post){
		if($post->post_type!='evo-rsvp')
			return;
			
		// Stop WP from clearing custom fields on autosave
		if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE)	return;

		// Prevent quick edit from clearing custom fields
		if (defined('DOING_AJAX') && DOING_AJAX)	return;
		
		// verify this came from the our screen and with proper authorization,
		// because save_post can be triggered at other times
		if( isset($_POST['evorsvp_nonce']) && !wp_verify_nonce( $_POST['evorsvp_nonce'], plugin_basename( __FILE__ ) ) ){
			return;
		}

		// Check permissions
		if ( !current_user_can( 'edit_post', $post_id ) )	return;	

		global $pagenow;
		$_allowed = array( 'post-new.php', 'post.php' );
		if(!in_array($pagenow, $_allowed)) return;
		

		$fields = array(
			'count', 'first_name','last_name','email','phone',
			'rsvp','updates','e_id','repeat_interval',
			'additional_notes'
		);

		// add form fields
			foreach( EVORS()->rsvpform->get_form_fields() as $key=>$v){
				$fields[] = $key;
			}

		// Append additional fields
			for($x = 1; $x <= EVORS()->frontend->addFields; $x++){
				$fields[]= 'evors_addf'.$x.'_1';
			}


		// Pluggable action to perform for special fields
			do_action('evors_save_other_metadata', $post_id);

		// Foreach field save data
			foreach($fields as $field){
				if(!empty($_POST[$field])){
					update_post_meta( $post_id, $field, $_POST[$field] );
				}else{
					if($field!='e_id')
						delete_post_meta($post_id, $field);
				}
			}

		// sync event rsvp count
			if(!empty($_POST['e_id'])){
				$RSVP = new EVORS_Event( $_POST['e_id'] );
				$RSVP->sync_rsvp_count();
			}
	}

// RSVP meta box for EVENT posts
	
	function event_metabox_content(){

		EVO()->admin_elements->print_loading_metabox_skeleton(
			array(
				'id'=> 'evors_content',
				'class'=>'evors_content',
				'nonce_key'=> '',
			)
		);
	}
	function eventedit_dom_ids($array, $postdata, $EVENT, $id){
		$array['evors'] = 'evors_content';
		return $array;
	}
	public function eventedit_pageload_data($array, $postdata, $EVENT, $dom_id_array){
		if( !array_key_exists( 'evors', $dom_id_array )) return $array;

		$array['evors'] = $this->get_event_edit_settings_content( $postdata, $EVENT );
		return $array;
	}
	// remove after eventon 4.8.3
	function legacy_eventedit_content($array, $postdata, $EVENT, $id){
		if( $id && $id != 'evors') return $array;
		
		$array['evors'] = $this->get_event_edit_settings_content( $postdata, $EVENT );
		return $array;
	}

	private function get_event_edit_settings_content($postdata, $EVENT){
		ob_start();
		include_once('metabox-content_event.php');
		return ob_get_clean();
	}

/** Save the menu data meta box. **/
	function evoRS_save_meta_data($arr, $post_id){
		$fields = apply_filters('evors_event_metafield_names', array( 'evors_rsvp' ), $post_id);

		foreach($fields as $field){
			if(!empty($_POST[$field])){
				update_post_meta( $post_id, $field, $_POST[$field] );
			}
		}
			
	}
}
new evors_meta_boxes();