/**
 * Javascript: RSVP Events Calendar
 * @version  3.0.12
 */
jQuery(document).ready(function($){
	

	var JDATA = {};	
	var submit_open = false;
	

	// load JSON DATA for event's rsvp into local object
		function load_json_to_local(O){
			JDATA = O.closest('.evo_metarow_rsvp').find('.evors_jdata').data('j');
		}	

	// RSVP form function 
	$.fn.evors_form = function (opt){
		var form = this;
		const form_holder = form.closest('.evors_forms');

		var formtype = form.find('input[name="formtype"]').val();
	
		works = {
			reset_notifications: function(elm){
				$('.evors_lightbox_body').removeClass('error');
				$('.evolb_content').removeClass('error');
				elm.removeClass('err');
				$('.evors_lightbox_body').find('.notification').hide();
			},
			interaction: function(){
				
				var ERROR = false;

				// capacity check 
				form.on('change','input[name="count"]', function(){

					//ERROR = false;
					var O = $(this);

					// reset
					works.reset_notifications( O );
					
					CAP = JDATA.cap;
					true_capacity = JDATA.true_cap;
					PERCAP = JDATA.precap;
					form = O.closest('.evors_submission_form');
					const oldCount = O.data('oval');
					const rsvp_type = form.find('input[name=rsvp_type]').val();

					VAL = parseInt(O.val()); // new rsvp count
					original_rsvp_cap = parseInt( O.attr('value') );

					// change RSVP form
					if( formtype == 'update'){ // updating a rsvp
						//console.log(CAP);
						//console.log(VAL +' '+original_rsvp_cap + ' '+ oldCount);
						//console.log(true_capacity);

						// for waitlist -- addon hook
						if( CAP == 'wl' ){ // available capacity is 0 & waitlist is ON
							// no space left but waitlist
							if(  VAL > original_rsvp_cap ){ // if increasing spaces
								$(this).addClass('err');
								works.show_msg('err9'); 
								ERROR = true;
							}
						}else{

							// if increasing the count
							//if( O.data('oval')) original_rsvp_cap = parseInt( O.data('oval'));
							if( VAL > original_rsvp_cap  ){
								const increased_spaces = VAL - original_rsvp_cap;

								if( increased_spaces > true_capacity ){
									//O.val( original_rsvp_cap );// reset the count to available max
									$(this).addClass('err');
									works.show_msg('err9'); 
									ERROR = true;
								}
							}
						}
						
					}else{
						// check avialable space vs party size
							if(VAL > parseInt(CAP) && CAP!= 'na'){
								$(this).addClass('err');
								works.show_msg('err9','','', 2000 ); 
								ERROR = true;

								O.val( CAP ); // reset the capacity to max value
							}
						// check per each rsvp capacity vs party size
							if(VAL > parseInt(PERCAP) && PERCAP!= 'na'){
								$(this).addClass('err');
								works.show_msg('err10'); 
								ERROR = true;
							}
					}

					// no errors reset error notifications
					if( !ERROR ){
						works.reset_error();
					}

					// if valid capacity add additional guests
					if(!ERROR){					

						var guestNames = form.find('.form_guest_names');
						var maskField = `<input class="regular input" name="names[]" type="text" placeholder="${evors_ajax_script.text.guest_name}">`;			
						var inputHolder = guestNames.find('.form_guest_names_list');


						if(VAL>1){							
							
							var ExistInputCount = inputHolder.find('input').length;
							
							// Add or remove input fields
	                        if ((VAL - 1) > ExistInputCount) { // Add
	                            var appender = '';
	                            for (var x = 0; x < (VAL - 1 - ExistInputCount); x++) {
	                                appender += maskField;
	                            }
	                            inputHolder.append(appender);
	                        } else {
	                            inputHolder.find('input').each(function(index) {
	                                if (index >= (VAL - 1)) $(this).remove();
	                            });
	                        }
	                        guestNames.show();

						}else{
							guestNames.hide();
							inputHolder.html( maskField);
						}
					}
				});

				// change RSVP status within the form
				form.on('click', 'span.evors_choices', function(){
					var OBJ = $(this);

					var VAL = OBJ.data('val');
					form.attr('class','evors_gen_form evors_submission_form  rsvp_'+VAL);
					OBJ.siblings().removeClass('set');
					OBJ.addClass('set');

					OBJ.parent().siblings('input').val( VAL );
				});

				// plus minus changer 3.0.6
				$('body').on('evo_plusminus_changed', function(e, NEWQTY, MAX, OBJ){
					$(OBJ).siblings('input').trigger('change');
				});
				
				// close RSVP form from incard close button
				form.on('click','.evors_incard_close',function(){
					$(this).closest('.evors_incard_form').hide();
					// reset any selected RSVP choices
					$(this).closest('.evo_metarow_rsvp').find('.evors_choices').removeClass('set');
				});
				
	            // Checkbox field
	            form.on('click', '.evors_checkbox_field', function() {
	                var O = $(this);
	                if (O.hasClass('checked')) {
	                    O.removeClass('checked');
	                    O.siblings('input').val('no');
	                } else {
	                    O.addClass('checked');
	                    O.siblings('input').val('yes');
	                }
	            });
			},

			// show form message
			show_msg: function (code, type, message, hide_message ){

				if(message == '' || message === undefined){
					var C = form_holder.find('.evors_msg_').data('j');
					var classN = (type== undefined || type=='error' || type == '')? 'err':type;
					message = message || C.codes[code];
				}				
				form_holder.find('.notification').addClass(classN).show().find('p').html(message);
				form_holder.parent().addClass('error');
				form.addClass('error');

				if( hide_message > 0 ){
					setTimeout( function(){
						works.reset_error();
					}, hide_message );
				}
			},

			// reset form error message
			reset_error: function(){
				form_holder.find('.notification').hide().find('p').html('');
				form_holder.parent().removeClass('error');
				form.removeClass('error');
			}
		}

		works.interaction(); // Calling the interaction function

		return this;
	}
	

	// open RSVP form from anywhere @since 2.8.3
		$('body').on('click','.evors_trig_open_rsvp_form', function(event){
			event.preventDefault();
			event.stopPropagation();

			show_rsvp_form( $(this), $(this).attr('data-val'), 'submit');
		});
		$('body').on('click','.evoRS_status_option_selection span.evors_choices',function(){
			show_rsvp_form( $(this), $(this).attr('data-val'), 'submit');
		});
		
	// RSVP from eventtop
		$('body').on('click', '.evors_rsvpiable span.evors_choices', function(event){
			event.preventDefault();
			event.stopPropagation();

			load_json_to_local( $(this) );

			var obj = $(this),
				rsvp = obj.closest('.evors_rsvpiable'),
				evoet_rsvp = obj.closest('.evoet_rsvp'),
				ajaxdataa = {};

			ajaxdataa['rsvp']= obj.data('val');				
			ajaxdataa['lang']= rsvp.data('lang'); 
			ajaxdataa['uid']= rsvp.data('uid'); 
			ajaxdataa['updates']= 'no';	
			ajaxdataa['action']='the_ajax_evors_a7';
			ajaxdataa['repeat_interval']= rsvp.data('ri');
			ajaxdataa['e_id']= parseInt(rsvp.data('eid'));


			var event_uid = 'event_'+ ajaxdataa.e_id +'_'+ ajaxdataa.repeat_interval;
			
			$.ajax({
				beforeSend: function(){	
					evoet_rsvp.addClass('evoloading');	
				},
				type: 'POST',
				url:evors_ajax_script.ajaxurl,
				data: ajaxdataa,
				dataType:'json',
				success:function(data){
					if(data.status=='0'){
						$('body').trigger('evors_new_rsvp_eventtop');

						// update events eventwhere
						$('body').find('.eventon_list_event.'+event_uid).each(function(){
							
							// show success message
							evoet_rsvp.html(data.message);

							// update eventtop html content
							setTimeout( function(){
								evoet_rsvp.html( data.content_eventtop );
							},3000);
							

							$(this).find('.evors_eventtop_section_data').replaceWith(data.content);

							// update event card
							if( data.card_content !== undefined){
								$(this).find('.evors_eventcard_content').html( data.card_content);
							}
						});			
						
					}else{
						rsvp.append('<span class="error">'+data.message+'</span>');
					}
				},complete:function(){
					evoet_rsvp.removeClass('evoloading');
				}
			});	
		});
	
	// RSVP form submissions & update existing
		$('body').on('click', '.evors_submit_rsvpform_btn', function(e){	
			e.preventDefault();

			var obj = O = $(this),
				ajaxdataa = { },
				form = obj.closest('form.evors_submission_form'),
				FORMPAR = form.parent(),
				formSection = form.parent(),
				error = 0,
				formType = form.find('input[name="formtype"]').val(),
				lightbox = false;
			const $count = parseInt(form.find('input[name=count]').val() );
			const $countMax = parseInt(form.find('input[name=count]').data('max') );
			const newRSVP_status = form.find('input[name=rsvp]').val();

			// reset form error messages
				rsvp_hide_notifications();
				FORMPAR.parent().removeClass('error');
			
			// validation
				// capacity check
					if(error==0){
						var changeCount = $count;
						if(formType=='update'){
							pastVal = parseInt(form.find('input[name=count]').attr('data-oval'));
							changeCount = $count - pastVal;
						}

						
						if(form.find('.rsvp_status span.set').data('val')!='n' 
							&& JDATA.cap
							&& JDATA.cap !='na' 							
						){

							var error2 = false;

							// For waitlist: only error if updating and trying to increase count
			                if( JDATA.cap == 'wl' && formType == 'update' ){
			                    if( changeCount > 0 ) error2 = true;
			                }else if( JDATA.cap != 'wl' ){
			                    if( changeCount > parseInt(JDATA.cap) ) error2 = true;
			                }


							if( error2 ){
								//console.log('rr');
								error=4;
								form.find('input[name=count]').addClass('err');

								// Use err11 if waitlist and no spaces, else err9
			                    const errCode = (JDATA.cap == 'wl' && changeCount > 0) ? 'err11' : 'err9';
			                    rsvp_error(errCode,'','',form);
							}
						}
						// max count limit
						if( JDATA.precap!='na' && $count > parseInt(JDATA.precap) ){
							error=4;
							form.find('input[name=count]').addClass('err');
							rsvp_error('err10','','',form);
							//console.log('10');
						}
						//console.log(JDATA);

						// cap check for updating RSVP
						if( formType == 'update' && JDATA.cap != 'wl' && $count > $countMax && newRSVP_status != 'n'){
							error=4;
							form.find('input[name=count]').addClass('err');
							rsvp_error('err10','','',form);
							//console.log('10a');
						}
					}	
				// run through each rsvp field
					form.find('.form_row.req').each(function(index){
						
						const row = $(this);
						row.removeClass('err');

						// for text fields
						iO = $(this).find('input');

						if( iO.length > 0){
							$.each(iO, function(){
								ioo = $(this);

								// required checkbox field
								if( ioo.hasClass('checkbox') && ioo.val()=='no'){
									error = 1;
									row.addClass('err');
								}

								// check required fields filled
								if( ioo.val()=='' && ioo.is(":visible")){
									error = 1;
									row.addClass('err');
								}						

								if( ioo.val() == '' ) return true;
							});
						}
						

						// for required select fields
						if( $(this).find('select').length > 0 && $(this).find('select').val() == '-'){
							error = 1;
							row.addClass('err');
						}

										
					});

				// validate email
					if(error==0){
						var thisemail = form.find('input[name=email]');
						if(!is_email(thisemail.val().trim() )){
							thisemail.addClass('err');
							rsvp_error('err2','','', form); // invalid email address
							error = 2;
						}
					}	

				// validate human
					if(error==0){
						var human = rsvp_validate_human( form.find('input.captcha') );
						if(!human){
							error=3;
							rsvp_error('err6','','',form);
						}
					}	

			// if form type is wl-remove
				if(formType == 'wl-remove') error = 0;			
				
			// if no errors proceed
			if(error==0){
				var updates = form.find('.updates input').attr('checked');
					updates = (updates=='checked')? 'yes':'no';

				ajaxdataa['action']='the_ajax_evors';
				form.ajaxSubmit({			
				//$.ajax({
					beforeSend: function(){	
						//form.parent().addClass('loading');	
						O.addClass('evobtn_loader full');
					},
					type: 'POST',url:evors_ajax_script.ajaxurl,data: ajaxdataa,dataType:'json',
					success:function(data){
						if(data.status=='0'){

							
							FORMPAR.parent().html(data.message);
							EVENTCARD = $('body').find('.event_'+data.e_id+'_'+ data.ri );

							// if lightbox event
							lb_eventcard = $('body').find('.evo_lightbox_body.event_'+ data.e_id+'_'+ data.ri);
							
							// update event top data
								if( 'data_content_eventtop' in data){
									// lightbox
									if(lb_eventcard.find('.evors_eventtop_section_data').length>0){
										lb_eventcard.find('.evors_eventtop_section_data').replaceWith(	data.data_content_eventtop	);
									}

									// calednar
									if(EVENTCARD.find('.evors_eventtop_section_data').length>0){
										EVENTCARD.find('.evors_eventtop_section_data').replaceWith(	data.data_content_eventtop	);
									}
								}
								if('data_content_eventtop_your' in data){
									// lightbox
									if(lb_eventcard.find('.evors_eventop_rsvped_data').length>0){
										lb_eventcard.find('.evors_eventop_rsvped_data').replaceWith(	data.data_content_eventtop_your	);
									}
									// calendar
									if(EVENTCARD.find('.evors_eventop_rsvped_data').length>0){
										EVENTCARD.find('.evors_eventop_rsvped_data').replaceWith(	data.data_content_eventtop_your	);
									}
								}

							// update Event Card
								if(data.e_id){					
									if(data.data_content_eventcard != ''){
										const incard_form_html = EVENTCARD.find('.evors_incard_form').html();

										EVENTCARD.find('.evors_eventcard_content').html( data.data_content_eventcard);
										lb_eventcard.find('.evors_eventcard_content').html( data.data_content_eventcard);

										// update incard rsvp form @since 2.8.4
										if( EVENTCARD.find('.evors_incard_form').is(":visible") ){
											EVENTCARD.find('.evors_incard_form').html( incard_form_html ).show();
										} 
											
									}
								}
							// update event manager stuff
								if( $('body').find('#rsvp_event_'+data.e_id).length>0 && data.new_rsvp_text){
									STATUS = $('#rsvp_event_'+data.e_id).find('span.rsvpstatus');
									STATUS.html( data.new_rsvp_text);
									STATUS.attr('class','rsvpstatus status_'+data.new_rsvp_text);
								}	

							// update virtual event information
								if( $('body').find('.evo_vir_data').length>0){
									const vir_data_box =  $('body').find('.evo_vir_data');

									if( vir_data_box.data('single') !== undefined 
										&& vir_data_box.data('single') == 'y' && 
										vir_data_box.data('refresh')
									){
										extra_data = {};
										extra_data['refresh_main'] = 'yy';
										$('body').trigger('evo_refresh_designated_elm',[ vir_data_box,'evo_vir_data', extra_data]);
									}
								}
								

						}else{
							var passedRsvppd = (data.status)? 'err'+data.status:'err7';
							rsvp_error(passedRsvppd, '', data.message,form);
						}
					},complete:function(){	
						form.parent().removeClass('loading');	
						O.removeClass('evobtn_loader full');
					}
				});				
			}else if(error==1){	rsvp_error('err','','',form);	}	
		});
	
	// CHANGE RSVP
		// change a RSVP
			$("body").on('click','.evors_change_rsvp_trig',function(e){	
				e.preventDefault();			
				OBJ = $(this);
				
				// extra data
				var _extra_data = {};
				_extra_data['rsvpid'] = OBJ.data('rsvpid');

				show_rsvp_form(OBJ, '','update', _extra_data );
			})
			// find rsvp form from rsvo form
			.on('click','#lookup_rsvp_trig',function(e){
				e.preventDefault();
				OBJ = $(this);
				var _extra_data = {};
				//_extra_data['rsvpid'] = OBJ.data('rsvpid');
				_extra_data['force_change'] = true;
				OBJ.addClass('evobtn_loader full');
				show_rsvp_form(OBJ, '','update', _extra_data );
			});

		// from successful rsvped page
			$('body').on('click','.evors_change_trig',function(){
				OBJ = $(this);
				
				// loading animation
				OBJ.closest('.evors_forms').addClass('loading');

				// load Json data					
				JDATA = OBJ.data('j');

				show_rsvp_form(OBJ, '','update');
			});
		// From rsvp manager
			$('.eventon_rsvp_rsvplist').on('click','.update_rsvp',function(){
				OBJ = $(this);
				PAR = OBJ.parent();

				// load Json data					
				JDATA = OBJ.parent().siblings('.evors_jdata').data('j');				

				show_rsvp_form(OBJ, '','update');
			});

	// Show RSVP lightbox form
		function show_rsvp_form(OBJ, RSVP,formtype, extra_data){
			var ajaxdataa = {};
			ajaxdataa['action']='evors_get_rsvp_form';			

			ROW = OBJ.closest('.evo_metarow_rsvp');
			if(OBJ.closest('.evo_metarow_rsvp').length) load_json_to_local( OBJ);
		
			if(JDATA){
				$.each(JDATA, function(index, val){
					ajaxdataa[index] = val;
				});
			}

			if( extra_data && extra_data !== undefined){
				$.each(extra_data, function(ind, vall){
					ajaxdataa[ ind ] = vall;
				});
			}

			ajaxdataa['rsvp'] = RSVP;
			ajaxdataa['formtype'] = formtype;
			const FORM = OBJ.closest('.evors_forms');
			FORMNEST = FORM.parent();
			
			$.ajax({
				beforeSend: function(){ 	loading(OBJ);		},					
				url:	evors_ajax_script.ajaxurl,data: 	ajaxdataa,	dataType:'json', type: 	'POST',
				success:function(data){
					if(data.status=='good'){
						// show form inside eventcard
						if( ajaxdataa.incard =='yes'){
							ROW.find('.evors_incard_form')
								.removeClass('error')
								.html( data.content )
								.slideDown('fast');							
						// open dynamic lightbox
						}else{

							var is_LB_exists = $('body').find('.evors_lightbox.evo_lightbox').length ? true: false;

							
							if( is_LB_exists ){
								const LB = $('body').find('.evors_lightbox.evo_lightbox');
								LB.find('.evolb_content').html( data.content);
							}else{
								var lb_ajax_data = {
									lbdata:{
										class:'evors_lightbox',
										padding:'evopad0',
										additional_class: ( ajaxdataa['form_style'] == 'clean' ? 'clean':''),
										content: data.content
									},
									adata:{	end:'_client'	}
								};
								ROW.evo_lightbox_open( lb_ajax_data );
							}

							// Change rsvp form -- focus on input field
							if( ajaxdataa.formtype == 'update' && ajaxdataa.rsvpid == ''){
								setTimeout(function(){ $('body').find('.evors_findrsvp_trig').focus(); },500);
							}

							$('body').trigger('evolightbox_show');
						}

						$('body').find('form.evors_gen_form').evors_form();
						
					}else{
						// error notice ***
					}
				},complete:function(){ 
					completeloading(OBJ);	
					FORMNEST.closest('.evorow').removeClass('loading');
					FORM.removeClass('loading');
				}
			});
		}

		// during ajax eventcard loading
			function loading(obj){					

				if( obj.hasClass('change')){
					obj.addClass('evobtn_loader');
					return;
				} 

				obj.closest('.evorow').addClass('loading');	
				obj.closest('.trig_evo_loading').addClass('evoloading');	
				obj.closest('p.rsvpmanager_event').addClass('loading');	
			}
			function completeloading(obj){
				obj.closest('.evorow').removeClass('loading');
				obj.closest('.trig_evo_loading').removeClass('evoloading');
				obj.closest('p.rsvpmanager_event').removeClass('loading');	

				if( obj.hasClass('change')) obj.removeClass('evobtn_loader');
			}
		
		// Find RSVP
			$(document).on('keypress', '.evors_findrsvp_trig', function (e) {
			    if (e.which === 13) { // Enter key
			        e.preventDefault(); // Prevent default Enter behavior (e.g., newline)
			        $('body').find('.evors_findrsvp_form_btn').trigger('click');
			    }
			});
			$('body').on('click','.evors_findrsvp_form_btn', function(){
				var obj = $(this);			
				var form = obj.closest('form.evors_findrsvp_form');				
				var error = 0;

				// get form data
				var formdata = form.serializeArray().reduce(function(obj, item) {
				    obj[item.name] = item.value;
				    return obj;
				}, {});

				f_holder = obj.closest('.evors_forms');

				// run through each rsvp field
					form.find('.input').each(function(index){
						// check required fields filled
						if( $(this).hasClass('req') && $(this).val()=='' ){
							error = 1;
						}
					});							
				if(error=='1'){
					rsvp_error('err','','',form);
				}else{
					var ajaxdataa = {};
					ajaxdataa['action']='evors_find_rsvp_form';
					form.ajaxSubmit({
						beforeSend: function(){ 	obj.addClass('evobtn_loader full');		},
						url:	evors_ajax_script.ajaxurl,
						data: 	ajaxdataa,	dataType:'json', type: 	'POST',
						success:function(data){
							if(data.status=='good'){

								if( formdata.incard == 'yes'){

								}else{

								}

								f_holder.parent().removeClass('error').addClass('t');
								f_holder.parent().html( data.content );

								$('body').find('form.evors_gen_form').evors_form();
								
							}else{
								rsvp_error('err5','','',form);
							}
							obj.removeClass('evobtn_loader full');
						},complete:function(){ 		}
					});
				}				
			});
			
	// hover over guests list icons
		$('body').on('mouseover','.evors_whos_coming span.initials', function(){
			OBJ = $(this);
			EM = OBJ.parent().find('em.tooltip');
			TEXT = OBJ.data('name');

			POS = OBJ.position();
			
			EM.css({'left':(POS.left+20), 'top':(POS.top-30)}).html(TEXT).show();

		});
		$('body').on('mouseout','.evors_whos_coming span', function(){
			OBJ = $(this);
			EM = OBJ.parent().find('em.tooltip');
			EM.hide();
		});

	// Buddypress profile linking
		$('body').on('click','.evors_whos_coming span',function(){
			LINK = $(this).data('link');

			if(LINK != 'na')
				window.open(LINK, '_blank');
		});

	

// ADDONS
	// action  user event manager
		// show rsvp stats for events
			$('#evoau_event_manager').on('click','a.load_rsvp_stats',function(event){
				event.preventDefault();					
				O = $(this);

				var data_arg = {
					eid: O.data('eid'),
					ri: O.data('ri'),
					data: O.closest('.evoau_manager').find('.evoau_manager_json').data('js')
				};

				load_rsvp_stats( O , data_arg);
			});
		// refresh rsvp data
			$(document).on('click','.evorsau_refresh_data',function(){
				O = $(this);
				var data_arg = {
					eid: O.closest('.evoau_manager_continer').data('eid'),
					ri: O.closest('.evoau_manager_continer').data('ri'),
					data: O.closest('.evoau_manager').find('.evoau_manager_json').data('js')
				};

				load_rsvp_stats( O , data_arg, true);
			});

			function load_rsvp_stats(O, data_arg, refresh){
				data_arg['action'] = 'evors_ajax_get_auem_stats';
				MANAGER = O.closest('.evoau_manager');
				$.ajax({
					beforeSend: function(){
						MANAGER.find('.trig_evo_loading').addClass('evoloading');
						MANAGER.find('.eventon_actionuser_eventslist').addClass('evoloading');
					},
					type: 'POST',
					url:evors_ajax_script.ajaxurl,
					data: data_arg,
					dataType:'json',
					success:function(data){
						if( refresh){
							MANAGER.find('.evoau_manager_event_content').html( data.html );
						}else{
							$('body').trigger('evoau_show_eventdata',[MANAGER, data.html, true]);
						}
						
	           		},complete:function(){ 
						MANAGER.find('.eventon_actionuser_eventslist').removeClass('evoloading');
						MANAGER.find('.trig_evo_loading').removeClass('evoloading');
					}
				});
			}

		// find an attendee
			$(document).on('click','.evorsau_trig_find_attendee',function(){
				$(this).parent().siblings('.evorsau_find_rsvp').toggle();
			});
			$(document).on('change paste keyup','input.evorsau_find_attendee',function(){
				var O = $(this);
				var val = O.val();
				const section = O.closest('.evorsau_attendee_list');

				section.find('li').each(function(){
					var show = false;
					// if rsvp id typed and it matches
					if( val == $(this).data('rsvpid')) show = true;
					if( val == $(this).data('e')) show = true;
					if( $(this).data('e').includes( val)) show = true;
					if( val == '') show = true;

					(show) ? $(this).show(): $(this).hide();
				});
			});

		// register attendee on the spot
			$('body').on('click','.evorsau_trig_rsvp_form',function(){
				OBJ = $(this);
				// load Json data					
				JDATA = OBJ.siblings('.evors_jdata').data('j');

				var extra_data = {};
				extra_data['loginuser'] = 'no';
				show_rsvp_form(OBJ, '','submit', extra_data);
			});

		// checkin guests
			$('.evoau_manager_event').on('click','span.checkin',function(){
				var obj = $(this);
				var PAR = obj.closest('.evorsau_attendee_list');

				if(!PAR.hasClass('checkable')) return false;

				var status = obj.attr('data-status');

				status = (status=='' || status=='check-in')? 'checked':'check-in';

				var data_arg = {
					action: 'the_ajax_evors_f4',
					rsvp_id: obj.attr('data-id'),
					status:  status,
					nonce: PAR.find('input#evors_nonce').val()
				};
				$.ajax({
					beforeSend: function(){
						obj.html( obj.html()+'...');
					},
					type: 'POST',
					url:evors_ajax_script.ajaxurl,
					data: data_arg,
					dataType:'json',
					success:function(data){
						//alert(data);
						obj.attr({'data-status':status}).html(data.new_status_lang)
						.removeAttr('class')
						.addClass(status+' checkin');
					}
				});
			});
	// waitlist 
	// Remove from waitlist
		$('body').on('click','.evorsw_remove_wl',function(){

			FORM = $(this).closest('form');

			// update form values to remove from waitlist
			FORM.find('input[name="formtype"]').val('wl-remove');

			// submit form
			FORM.find('.evors_submit_rsvpform_btn').trigger('click');
			
		});

// Supporting functions		
	// eventon 4.9.2 -- remove
		$('body').on('click', '.evo_elm_dynamic_select_trig',function(e){
			e.preventDefault();
		});
	// show error messages
		function rsvp_error(code, type, message, O){
			FORM = O.closest('.evors_forms');
			F = FORM.find('form');

			if(message == '' || message === undefined){
				var C = FORM.find('.evors_msg_').data('j');
				var classN = (type== undefined || type=='error' || type == '')? 'err':type;
				message = C.codes[code]
			}				
			FORM.find('.notification').addClass(classN).show().find('p').html(message);
			FORM.parent().addClass('error');
			F.addClass('error');
		}

	// hide form messages
		function rsvp_hide_notifications(){
			$('.evors_lightbox_body').find('.notification').hide();
		}		
	// validate humans
		function rsvp_validate_human(field){
			if(field==undefined){
				return true;
			}else{
				var numbers = ['11', '3', '6', '3', '8'];
				if(numbers[field.attr('data-cal')] == field.val() ){
					return true;
				}else{ return false;}
			}				
		}
			
	function is_email(email){
		var regex = /^([a-zA-Z0-9_.+-])+\@(([a-zA-Z0-9-])+\.)+([a-zA-Z0-9]{2,4})+$/;
  		return regex.test(email);
	}
});