<?php
/**
 * checking in users
 *
 * @author 		AJDE
 * @category 	Admin
 * @package 	eventon-qr/classes
 * @version     2.1
 */

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
class EVOQR_Checkin{
	
	public $optQR, $cal, $opt2, $evocal;
	public $checkin_page_url = false;

	public $enable_custom_dir = false;

	public $qr_code_size = 200;

	function __construct(){
		$this->optQR = get_option('evcal_options_evcal_1');
		$this->opt2 = get_option('evcal_options_evcal_2');

		$this->cal = EVO()->cal;
		$this->cal->set_cur('evcal_1');

		$this->checkin_page_url = $this->get_checking_page_url();

		$this->evocal = new EVO_Calendar('evcal_1');


		// add QR code to eventon addons
		//rsvp addon
			add_action('eventonrs_rsvp_post_table', array($this, 'show_qr_rsvp_post'), 10, 2);
			add_action('eventonrs_confirmation_email', array($this, 'show_qr_rsvp_email'), 10, 2);
			add_action('evors_confirmation_email_before', array($this, 'generate_qr_image_rsvp'), 10, 1);
		// event tickets addon
			add_filter('evotx_tixPost_tixid', array($this, 'show_qr_code_TX'), 10, 2);
			add_filter('evotx_email_tixid_list', array($this, 'show_qr_code_TX2'), 10, 3);
			add_action('evotx_one_ticket_extra', array($this, 'show_qr_code_TX3'), 10, 3);

		// modify uploads
			add_filter('upload_dir', array($this, 'custom_upload_dir'));
			add_filter( 'wp_unique_filename', array( $this, 'update_filename' ), 10, 3 );
			add_filter('posts_where', array($this,'media_library_hide_qr_images'));
	}

	

	// initiate things
		public function init(){}

	// checking page content filtering
		function _print_page_content(){
			global $post;

			$content = $post->post_content;
			$get_shortcode = $this->_get_between($content, '[',']');

			echo apply_filters('the_content', '['.$get_shortcode.']');
		}
		private function _get_between($string, $start, $end){
			$string = ' ' . $string;
		    $ini = strpos($string, $start);
		    if ($ini == 0) return '';
		    $ini += strlen($start);
		    $len = strpos($string, $end, $ini) - $ini;
		    return substr($string, $ini, $len);
		}


	// QR Code 
		public function get_qr_code($ticket_number, $repeat_interval='', $size=150, $post_id = ''){	

			$imgUrl = false;

			// if there is a post set to assign 
			$gen_qr = true;

			//echo $ticket_number.' '. $this->evo_crypt( $ticket_number );

			if(!empty($post_id)){
				$p_url = get_post_meta($post_id, '_qrimg_'.$ticket_number.'_'.$repeat_interval, true);

				if($p_url){
					$gen_qr = false;
					return '<img src="'.$p_url.'"/>';
				}
			}
			
			if($gen_qr){
				$checkURL = $this->checkin_page_url;

				$row_ticket_number = $ticket_number; // row tn
				$encryptTN = $this->encrypt_TN($ticket_number); // encrypt tn if encrypt enabled

				$siteurl = $checkURL.'?id='.$encryptTN. ( !empty($repeat_interval)? '&ri='.$repeat_interval: null);
				$chl = urlencode($siteurl);
				
				// load the QR CODE image from 3rd party service
				$imgUrl ='https://api.qrserver.com/v1/create-qr-code/?data='.$chl.'&size='.$size.'x'.$size.'';
             
				//$imgUrl = 'https://chart.googleapis.com/chart?chs='.$size.'x'.$size.'&cht=qr&chl='.$chl;
				
				$u_url = $this->get_uploaded_qr_code_image($imgUrl, $encryptTN, $post_id);

				if($u_url && !empty($post_id)){
					update_post_meta($post_id, '_qrimg_'.$row_ticket_number.'_'.$repeat_interval, $u_url);
					$imgUrl = $u_url;
				}
			}

			return $imgUrl? '<img src="'.$imgUrl.'"/>' : '';
		}

		// return the uploaded QR code image url
			function get_uploaded_qr_code_image($qr_url, $ticket_number, $post_id=''){
				if(empty($qr_url)) return false;

				$_POST['type'] = 'eventon_qr_code';
				$this->enable_custom_dir = true;

				$file_array = array();
				$desc = "QR Code Image for post ID:".$post_id." on ". date('Y-m-d', time());
		    				
				// Need to require these files
				if ( !function_exists('media_handle_upload') ) {
					require_once(ABSPATH . "wp-admin" . '/includes/image.php');
					require_once(ABSPATH . "wp-admin" . '/includes/file.php');
					require_once(ABSPATH . "wp-admin" . '/includes/media.php');
				}

				$tmp = download_url( $qr_url );
				
				$file_array['name'] = "qr_code.png";
		      	$file_array['tmp_name'] = $tmp_name = $tmp;

				if( is_wp_error( $tmp ) ){
					//@unlink($file_array['tmp_name']);
	        		$file_array['tmp_name'] = '';
				}

				// Set variables for storage
				if(empty($post_id)) $post_id = 1;

		      	// do the validation and storage stuff	      
		      	$result = media_handle_sideload( $file_array, $post_id, $desc );


		      	// If error storing permanently, unlink
			    if ( is_wp_error($result) ) {
			         //@unlink($file_array['tmp_name']);
			         return false;
			    }

			    $_POST['type'] = '';
			    $this->enable_custom_dir = false;

			    return  wp_get_attachment_url( $result );

			}

			// alter upload folder only for qr code images
			function custom_upload_dir($pathdata){

				if( !$this->enable_custom_dir) return $pathdata;
				if( !isset($_POST['type']) ) return $pathdata;
				if( $_POST['type'] != 'eventon_qr_code') return $pathdata;

				
				$custom_dir = 'evo_qr_codes';
				$pathdata['path'] = $pathdata['basedir'] . '/'. $custom_dir;
				$pathdata['url'] = $pathdata['url'] . '/'. $custom_dir;
				$pathdata['subdir'] = '/'. $custom_dir;
				

				return $pathdata;
			}

			// change file name for qr code and prepend uniqu chars
			function update_filename($full_filename, $ext, $dir){
				if ( ! isset( $_POST['type'] ) || ! 'eventon_qr_code' === $_POST['type'] ) {
					return $full_filename;
				}

				if ( ! strpos( $dir, 'evo_qr_codes' ) ) return $full_filename;

				return $this->unique_filename( $full_filename, $ext );
			}

			// change file name to append random chars
			public function unique_filename( $full_filename, $ext ) {
				$ideal_random_char_length = 6;   // Not going with a larger length because then downloaded filename will not be pretty.
				$max_filename_length      = 255; // Max file name length for most file systems.
				$length_to_prepend        = min( $ideal_random_char_length, $max_filename_length - strlen( $full_filename ) - 1 );

				if ( 1 > $length_to_prepend ) {
					return $full_filename;
				}

				$suffix   = strtolower( wp_generate_password( $length_to_prepend, false, false ) );
				$filename = $full_filename;

				if ( strlen( $ext ) > 0 ) {
					$filename = substr( $filename, 0, strlen( $filename ) - strlen( $ext ) );
				}

				$full_filename = str_replace(
					$filename,
					"$filename-$suffix",
					$full_filename
				);

				return $full_filename;
			}

			// hide qr code images from media library
			public function media_library_hide_qr_images($where){

				if ( ! is_admin() )    return $where;

				if( EVO()->cal->check_yn('evoqr_show_in_media','evcal_1')) return $where;

				global $wpdb, $pagenow;
				
				$execute = false;

				if( !empty($pagenow) && $pagenow == 'upload.php') $execute = true;
				if( isset($_REQUEST['action']) && $_REQUEST['action'] == 'query-attachments') $execute = true;


				if($execute) 
					$where .= ' AND ' . $wpdb->posts . '.post_title NOT LIKE \'QR Code Image%\'';
			   
			    return $where;
			}
			

	// show QR code for addons
		// RSVP addon
			public function show_qr_rsvp_post($rsvpid, $rsvp_pmv){
				$repeat_interval = (!empty($rsvp_pmv['repeat_interval']))? $rsvp_pmv['repeat_interval'][0]:0;
				echo "<tr><td>QR Code: </td><td>
					<em class='evoqr_qr' style='float:left; padding-right:10px'>".
						$this->get_qr_code($rsvpid, $repeat_interval, $this->qr_code_size, $rsvpid)."</em>
					<em class='evoqr_code' style='padding-top:25px; display:inline-block'># ".$rsvpid."</em>
					</td></tr>";
			}
			// generate qr code image for rsvp before sending email
			function generate_qr_image_rsvp($rsvp_id){

				$rsvp_pmv = get_post_custom($rsvp_id);
				
				$repeat_interval = (!empty($rsvp_pmv['repeat_interval']))? $rsvp_pmv['repeat_interval'][0]:0;							
				// if RSVP status is no then stop
				if(!empty($rsvp_pmv['rsvp']) && $rsvp_pmv['rsvp'][0] == 'n') return false;
				
				// Generate QR Code image for RSVP
				$this->get_qr_code($rsvp_id, $repeat_interval, $this->qr_code_size, $rsvp_id);
			}

			public function show_qr_rsvp_email($RSVP, $eRSVP){
				$repeat_interval = $RSVP->repeat_interval();							
				
				// if RSVP status is no then stop
				if( $RSVP->get_prop('rsvp') == 'y'){
				
				?>
					<p style="color:#303030; text-transform:uppercase; font-size:18px; font-style:italic; padding-bottom:0px; margin-bottom:0px; line-height:110%;">QR Code</p>
					<p style="color:#afafaf; font-style:italic;font-size:14px; margin:0 0 10px 0; padding-bottom:10px;"><?php echo eventon_get_custom_language($this->opt2, 'evoQR_008', 'You can use the below QRcode to checkin at the event');?></p>
					<p><?php echo $this->get_qr_code($RSVP->ID, $repeat_interval, $this->qr_code_size, $RSVP->ID);?></p>
					<?php
				}
			}
		//Ticket addon
			public function show_qr_code_TX($ticket_number, $TD){
				return $ticket_number;					
			}
			// for emails and order details page
			public function show_qr_code_TX2($encrypt_TN, $ticket_number, $this_ticket){

				if( isset($this_ticket['s']) && $this_ticket['s'] == 'refunded') 
					return $this->encrypt_TN( $ticket_number );

				$evo_tix_id = explode('-', $ticket_number);
				$evo_tix_id = (int)$evo_tix_id[0];

				// get the qr code image size
				$qr_code_size = apply_filters('evotx_qrcode_email_size', $this->qr_code_size);

				//return get_post_meta($post_id, '_qrimg_'.$ticket_number.'_', true).'XX';

				return "<em style=''>".$this->get_qr_code($ticket_number,'',$qr_code_size, $evo_tix_id)."</em><em style='display:block; line-height:100%; padding-top:10px; padding-bottom:5px; font-style:normal;'>". $this->encrypt_TN($ticket_number) ."</em>";
			}
			// on one ticket
			function show_qr_code_TX3($TN, $TD, $type){

				if( isset($TD['oS']) && $TD['oS'] != 'completed') return false;
				if( isset($TD['s']) && $TD['s'] == 'refunded') return false;


				$evo_tix_id = explode('-', $TN);
				$evo_tix_id = (int)$evo_tix_id[0];

				// get the qr code image size
				$qr_code_size = apply_filters('evotx_qrcode_size', $this->qr_code_size);

				echo "<em class='evotxVA_qrcode' style='padding-top:10px;display:block;'>".$this->get_qr_code($TN,'',$qr_code_size, $evo_tix_id)."</em>";

			}
	
	

	// validate the ticket number for both tix and rsvp @+ 1.1.7
		public function validate_tickets( $tixid ){

			if( empty($tixid) ) return false;
			$tixid = trim($tixid);

			// differentiate ID type
			if(strpos($tixid, '-')){
				$tt = explode('-', $tixid);
				$post_exists = (get_post_status($tt[0] ) !== FALSE)? true: false;
				$id_type = get_post_type($tt[0]);
			}else{
				$post_exists = (get_post_status($tixid ) !== FALSE)? true: false;
				$id_type = get_post_type($tixid	);
			}

			if( !$post_exists ) return false;			
				
			// for tickets
			if($id_type=='evo-tix'){				
				$ticket = new EVO_Ticket( $tixid );
				$saved_tn = $ticket->get_ticket_number();
				if($saved_tn != $tixid) return false;

			// for rsvp
			}else{					
				// post exists value checks for this
			}

			return true;

		}

	
			
		// process tn ecrypt or not
		function encrypt_TN($TN){
			$dis_encrypt = EVO()->cal->check_yn('evoqr_encrypt_dis','evcal_1');

			// if said to disable encryption
			if($dis_encrypt) return $TN;

			return base64_encode($TN);
		}

		// process ticket number if encoded
		function process_ticket_number(){

			$tn = (!empty($_GET['id'])? $_GET['id']: false);
			if(!$tn) return false;

			// remove # sign
			$tn = str_replace('#', '', $tn);

			// if a full url passed as ticket number
			if(strpos($tn, 'http')!== false){
				$tn_1 = explode('http', $tn);
				$tn_2 = explode('?id=', $tn_1[1]);
				$tn = $tn_2[1];
			}elseif( is_numeric($tn)){
				return $tn;
			}


			return $this->decrypt_ticket_number( $tn );

		}		
		// decrypt a ticket number if encrypted 
			// @version 2.0
			public function decrypt_ticket_number( $ticket_number ){

				if( $this->_is_base64encoded( $ticket_number)){
					return base64_decode($ticket_number);
				}

				return $ticket_number;
				
			}
			function _is_base64encoded($data){
				if (preg_match('%^[a-zA-Z0-9/+]*={0,2}$%', $data)) {
			       return TRUE;
			    } else {
			       return FALSE;
			    }
			}
		// custom decrypt and encrypt function
			function evo_crypt($code, $action = 'e'){
				$secret_key = 'evotx_secret_key';
			    $secret_iv = 'evotx_secret_iv';
			 
			    $output = false;
			    $encrypt_method = "AES-256-CBC";
			    $key = hash( 'sha256', $secret_key );
			    $iv = substr( hash( 'sha256', $secret_iv ), 0, 16 );
			 
			    if( $action == 'e' ) {
			        $output = base64_encode( openssl_encrypt( $code, $encrypt_method, $key, 0, $iv ) );
			    }
			    else if( $action == 'd' ){
			        $output = openssl_decrypt( base64_decode( $code ), $encrypt_method, $key, 0, $iv );
			    }
			 
			    return $output;
			}

		// check if user has permissions
			function is_user_have_permission_to_checkin(){
				$_permission_grants = false;

				if(is_user_logged_in()){
					global $current_user, $wp_roles;
					$allowed_roles = array('administrator');

					// add other user roles set via settings for checking in guests
					if(!empty($this->optQR['evoqr_001'])){
						$allowed_roles = array_merge($allowed_roles, $this->optQR['evoqr_001']);
					}
					
					//print_r($allowed_roles);
					foreach($allowed_roles as $role){
						if(array_key_exists($role, $current_user->caps)){
							$_permission_grants = true;
						}
					}
				}
				return $_permission_grants;
			}

		// Checking page
			function get_checking_page_url(){

				$page_id = $this->cal->get_prop('eventon_checkin_page_id');
				return $page_id ? get_permalink($page_id):	get_bloginfo('url').'/checkin/';
			}

		// get other event data
			function get_other_event_data($arr, $type, $OBJ = ''){

				$output = array();

				$event_id = $terms_str = '';
				$event_ri = 0;

				// TICKETS
				if($type == 'tx'){
					// if $TIX object passed get name and email
					if( !empty($OBJ) && $OBJ){
						$output['ticket-holder-name'] = $OBJ->get_ticketholder_name();
						$output['email'] = $OBJ->get_ticketholder_email();

						// ticket purchaser information
						$purchaser_id = $OBJ->get_prop('_customerid');
						$purchaser = get_userdata($purchaser_id);

						if( $purchaser){
							$output['ticket-purchased-by'] = $purchaser->first_name .' '. $purchaser->last_name;
						}
					}

					if(!empty($arr['_eventid'])) $event_id = $arr['_eventid'];	
					$output['count'] = (!empty($arr['qty']) )?  $arr['qty'] : 1;	

					// order id
						if(isset($arr['_orderid'])) $output['order-id'] = $arr['_orderid'];				
				
				// RSVP
				}else{

					$event_id = $arr->event_id();
					if(!$event_id) $event_id = null;

					$output['name'] = ($arr->first_name()? $arr->first_name().' ':'').($arr->last_name()? $arr->last_name():'');
					$output['count'] = ($arr->count())?  $arr->count() : 1;	

					$event_ri = $arr->repeat_interval();

					// Custom rsvp form fields
					$rsvp = new EVORS_Event( $event_id, $event_ri);
					$form_fields = EVORS()->rsvpform->get_form_fields($rsvp, $arr);
					foreach($form_fields as $key=>$fdata){					

						// skip fields
						if( in_array($key, array('count','phone'))) continue;
						extract( $fdata );
						$fieldval = $arr->get_prop($key) ? $arr->get_prop($key) : '-';

						// array value
						if( is_array( $fieldval))	$fieldval = implode(', ', $fieldval );

						$output[ $name ] = $fieldval;						
					}
				}


				if(!empty($event_id)){

					$EVENT = new EVO_Event($event_id,'',$event_ri);

					// event name
					$output['event-name'] = $EVENT->get_title();
			

					// event time
					$output['event-time'] = $EVENT->get_formatted_smart_time( $event_ri );

					// event type terms
					$terms = wp_get_post_terms($event_id,'event_type');
					$term_vals = array();
					if($terms){
						foreach($terms as $term){
							$term_vals[] = $term->name;
						}
						$terms_str = implode(', ', $term_vals);
						$output['event-type'] = $terms_str;
					}
				}
				

				return apply_filters('evoqr_checkin_otherdata_ar', $output, $arr, $type);
			}
}