<?php 
/**
 * QR Code Checkin Page content
 * @version 2.1
 */

class EVOQR_Checkin_Page{
	private $checking_page;

	// actual checking page data
		function checkin_page_content($atts=''){


			// if language value passed set it as global language for eventon
				if(isset($atts['lang']))	evo_set_global_lang($atts['lang']);
			
			$this->checking_page = $checking_page = EVOQR()->checkin->checkin_page_url;

			// process ticket number
			$tixid = EVOQR()->checkin->process_ticket_number();

			// login check
			if(!is_user_logged_in()){
				$this->_views('notloggedin');	
				return false;
			}

			// permission check
			if(!EVOQR()->checkin->is_user_have_permission_to_checkin()){
				$this->_views('nopermissions');	
				return false;
			}

			// check for ticket ID 
			if(!$tixid){
				$this->_views('noticket_id');	
				return false;
			}

			// validate ticket numbers
			if( !EVOQR()->checkin->validate_tickets( $tixid )){
				$this->_views('invalid_ticket_id');	
				return false;
			}


			// if loggedin and have permission
			$content = $this->get_page_data();
			if($content) extract($content);



			?>	
			<div class='evo_checkin_page evoboxbb <?php echo !empty($classes) ? $classes :'';?>'>
			
				<?php if(!empty($tixid)):?>
					<h2 class='tix_id'>
						<span class='evodb' style='opacity:0.5'><?php echo evo_lang('Ticket #');?></span>
						<span><?php echo $tixid;?></span>
					</h2>
					<?php 

					// input field for scanner gun
					if(EVO()->cal->get_prop('evoqr_mode','evcal_1')=='gun'):?>
					<?php $this->_views('scanner_gun_js');?>
					<div class='evpqr_content' style='padding:0 0 20px'>
						<form action='<?php echo $checking_page;?>' method='GET'>
							<p class=''>
								<input placeholder='<?php evo_lang_e('Look-up Another Ticket');?> #' type='text' name='id' class='another_id'/>
								<button class='evoqr_checkin_submit evcal_btn' type='submit' data-url='<?php echo $checking_page;?>'><?php evo_lang_e('Find Guest');?></button>
							</p>
						</form>
					</div>
					<?php endif;?>
				<?php endif;?>


				<?php $this->print_big_icon( $icon);	?>

				<h4><?php echo !empty($msg)?$msg:'';?></h4>

				<?php

				// after
					echo !empty($after)? $after: '';

				// other ticket information
					if(!empty($otherdata)):

						echo "<div class='evoqr_other_information'>";
						echo "<h5 class='evomarb10 evottu evopadt30 evopadb30'>". evo_lang('Ticket Information')."</h5>";
						echo "<ul>";

						foreach($otherdata as $field=>$value){
							if(empty($value)) continue;

							$label = evo_lang_get( 'evoQR_007_'.$field, str_replace('-',' ', $field));

							// convert order id to a button
							if( $field == 'order-id' && current_user_can('edit_posts') ){
								$value = '<a class="" href="'.get_edit_post_link($value).'" target="_blank">'.$value.' &rarr;</a>';
							}
							echo "<li class='evopadb10 evo_borderb evomarb10'><span class='evopadr15 evoop7 evottc evofsi'>".$label.':</span>'.$value.'</li>';
						}
						echo "</ul>";
						echo "</div>";

					endif;

					

					// other HTML content
					if(!empty($html)):
						echo "<div class='evpqr_content'>";
						echo $html;
						echo "</div>";
					endif;
				?>
			</div>
			<?php
		}

	// PAGE DATA
		function get_page_data(){
			// process ticket number
			$ticket_number = $tixid = EVOQR()->checkin->process_ticket_number();
			
			$post_exists = false;
			$checking_page = $this->checking_page;
			
			$ticket_meta_data = '';
			$classes = array(); 
			$output = array(
				'classes'=>'',
				'otherdata'=>'',
				'after'=>'',
				'msg'=>'',
				'tixid'=>$ticket_number,
				'icon'=>'good'
			);

			// differentiate ID type
				if(strpos($ticket_number, '-')){
					$tt = explode('-', $ticket_number);
					$post_exists = (get_post_status($tt[0] ) !== FALSE)? true: false;
					$id_type = get_post_type($tt[0]);
				}else{
					$post_exists = (get_post_status($ticket_number ) !== FALSE)? true: false;
					$id_type = get_post_type($ticket_number	);
				}
			

			// if a valid ticket id
			if(!empty($ticket_number) && $post_exists && ($id_type=='evo-rsvp' || $id_type=='evo-tix' )){

				// Tickets
				if($id_type=='evo-tix'){

					// pre process
						$TIX = new EVO_Ticket( $ticket_number );
						if( !$TIX->get_order_id() ) return false;						
						$OrderStatus = false;
						$current_status = $TIX->get_status();
						$order_id = $TIX->get_order_id();				
						$event_id = $TIX->get_event_id();
						$order = new WC_Order($order_id);

					// uncheck ticket
					if(!empty($_GET['action']) && $_GET['action']=='unc'){
						
						// change status to check-in
						if(!empty($current_status) && $current_status =='checked'){
							
							$TIX->set_status( 'check-in');
							$classes[] = 'yes'; $output['icon'] = 'unchecked';
							$output['msg'] = evo_lang_get( 'evoQR_001', 'Successfully un-checked ticket!');
							//echo '01';
						}else{
							$classes[] = 'yes'; $output['icon'] = 'unchecked';
							$output['msg'] = evo_lang_get( 'evoQR_002', 'Ticket already un-checked!');
							//echo '02';
						}
						// option to recheck or new
						$output['after'] = "<p class='mart20'><a class='btn' href='?id={$tixid}&action=check'><i class='fa fa-check evomarr10'></i>".evo_lang( 'Check this ticket')."</a> 
							<a class='btn' href='".$checking_page ."'><i class='fa fa-plus evomarr10'></i>".evo_lang('Enter a New Ticket ID')."</a></p>";	
					}else{
						
						$OrderStatus = $order->get_status();

						if( $OrderStatus == 'completed'){
							//check in a ticket 					
							if(empty($current_status) || $current_status =='check-in'){
								
								$TIX->set_status('checked');

								$classes[] = 'yes'; 
								$output['icon'] = 'good';
								$output['msg'] = evo_lang_get( 'evoQR_003', 'Successfully Checked!');	

								$output['after'] = "<p class='mart20'><a class='btn' href='?id={$tixid}&action=unc'><i class='fa fa-xmark evomarr10'></i>".evo_lang_get( 'evoQR_005', 'Un-check this ticket')."</a> <a class='btn' href='".$checking_page ."'><i class='fa fa-plus evomarr10'></i>".evo_lang('Enter a New Ticket ID')."</a></p>";										

							// refunded order
							}elseif($current_status == 'refunded'){
								$classes[] = 'refunded'; 
								$output['icon'] = 'exclaim';									
								$output['msg'] = evo_lang( 'Ticket has been refunded!');
								$output['after'] = "";
								
							}else{// already checkedin status = not-empty|checked
								$classes[] = 'yes'; 
								$classes[] = 'already_checked'; 
								$output['icon'] = 'exclaim';
								
								$output['msg'] = evo_lang_get('evoQR_004', 'Already checked!');
								$output['after'] = "<p class='mart20'><a class='btn' href='?id={$tixid}&action=unc'><i class='fa fa-xmark evomarr10'></i>".evo_lang_get('evoQR_005', 'Un-check this ticket')."</a> 
									<a class='btn' href='".$checking_page ."'><i class='fa fa-plus evomarr10'></i>".evo_lang('Enter a New Ticket ID')."</a></p>";	
							}	
						// order is not complete
						}else{
							$classes[] = $OrderStatus; 
							$classes[] = 'no';
							$output['icon'] = 'exclaim';

							switch($OrderStatus){
								case 'refunded': $_m = evo_lang('Ticket order is refunded!'); break;
								case 'cancelled': $_m = evo_lang('Ticket order is cancelled!'); break;
								default: $_m = evo_lang('Ticket order is not completed!'); break;
							}										
							$output['msg'] = $_m;
							$output['after'] = "";

							$output['after'] = "<p class='mart20'>
								<a class='btn' href='".$checking_page ."'><i class='fa fa-plus evomarr10'></i>".evo_lang('Enter a New Ticket ID')."</a></p>";	
						}				
					}

					// Show attendee and event information
						$tix_meta = $TIX->get_props();

						$output['otherdata'] = EVOQR()->checkin->get_other_event_data($tix_meta, 'tx', $TIX);
						
						if($OrderStatus) $output['otherdata']['order-status'] = $OrderStatus;

					// other tickets in the same order
						$EA = new EVOTX_Attendees();
						$TH = $EA->_get_tickets_for_order($order_id);


						// if there are more than one other tickets
						if($TH && isset($TH[$event_id])){

							if( isset($TH[$event_id][$ticket_number])) 
								$ticket_meta_data = $TH[$event_id][$ticket_number];
							
							if(  count($TH[$event_id])>1 ){
								$html = "<h5>".evo_lang('Tickets in the same order')."</h5>";
								foreach($TH[$event_id] as $_ticket_number=>$td){
									
									if($_ticket_number != $ticket_number){
										$html .= "<p>".$_ticket_number." <a style='margin-left:8px;' class='evcal_btn evoqr_other_tickets {$td['s']}' href='". $checking_page. "?id={$_ticket_number}'>".$td['s'].'</a></p>';
									}
								}
								
								$output['html'] = $html;
							}
						}

				}else{ // RSVP 

					$RSVP = new EVO_RSVP_CPT($tixid);
					//$rsvpMETA = $RSVP->pmv;

					$checkin_status = $RSVP->status();
					
					// uncheck a checked ticket
					if(!empty($_GET['action']) && $_GET['action']=='unc'){

						// change status to check-in
						if( $checkin_status =='checked'){
							update_post_meta($tixid, 'status','check-in');
							$classes[] = 'yes';
							$output['icon'] = 'good';
							$output['msg'] = evo_lang_get( 'evoQR_001', 'Successfully un-checked ticket!');
							
							// option to recheck or new
							$output['after'] = "<p class='mart20'>
								<a class='btn' href='?id={$tixid}&action=unc'><i class='fa fa-xmark evomarr10'></i>".evo_lang_get( 'evoQR_005', 'Un-check this ticket')."</a> 
								<a class='btn' href='".$checking_page ."'><i class='fa fa-plus evomarr10'></i>".evo_lang('Enter a New Ticket ID')."</a></p>";	
						}else{
							$classes[] = 'yes';
							$output['icon'] = 'good';
							$output['msg'] = evo_lang_get( 'evoQR_002', 'Ticket already un-checked!');

							// option to recheck or new
							$output['after'] = "<p class='mart20'>
								<a class='btn' href='?id={$tixid}&action=check'><i class='fa fa-check evomarr10'></i>".evo_lang( 'Check this ticket')."</a> 
								<a class='btn' href='".$checking_page ."'><i class='fa fa-plus evomarr10'></i>".evo_lang('Enter a New Ticket ID')."</a></p>";	
						}

						
					}else{ // check in a RSVP guests
						
						if(!$checkin_status || $checkin_status =='check-in'){
							// check whether coming to the event
							$rsvp_status = $RSVP->get_rsvp_status();
							if($rsvp_status !='n'){
								update_post_meta($tixid, 'status','checked');
								$classes[] = 'yes';
								$output['icon'] = 'good';
								$output['msg'] = evo_lang_get( 'evoQR_003', 'Successfully Checked!');

								// option to recheck or new
								$output['after'] = "<p class='mart20'>
									<a class='btn' href='?id={$tixid}&action=unc'><i class='fa fa-xmark evomarr10'></i>".evo_lang_get( 'evoQR_005', 'Un-check this ticket')."</a> 
									<a class='btn' href='".$checking_page ."'><i class='fa fa-plus evomarr10'></i>".evo_lang('Enter a New Ticket ID')."</a></p>";	
							}else{// not coming to the event
								$classes[] = 'no';
								$output['icon'] = 'bad';
								$output['msg'] = evo_lang_get( 'evoQR_003x', 'You have RSVPed NO!');

								// option to recheck or new
								$output['after'] = "<p class='mart20'>
									<a class='btn' href='".$checking_page ."'><i class='fa fa-plus evomarr10'></i>".evo_lang('Enter a New Ticket ID')."</a></p>";	
							}							
							
						}else{// already checkedin status = not-empty|checked|waitlist
							$classes[] = 'yes'; 
							$classes[] = 'already_checked'; 
							$output['icon'] = $checkin_status == 'waitlist'? 'waitlist': 'exclaim';

							$output['msg'] = $checkin_status == 'waitlist' ?
								evo_lang('In Waitlist!'):
								evo_lang_get( 'evoQR_004', 'Already checked!');
							$output['after'] = $checkin_status == 'waitlist' ?
								"<p class='mart20'><a class='btn' href='". $checking_page. "'><i class='fa fa-plus evomarr10'></i>".evo_lang('Enter a New Ticket ID')."</a></p>":
								"<p class='mart20'><a class='btn' href='?id={$tixid}&action=unc'><i class='fa fa-xmark evomarr10'></i>".evo_lang_get( 'evoQR_005', 'Un-check this ticket')."</a> <a class='btn' href='". $checking_page. "'><i class='fa fa-plus evomarr10'></i>".evo_lang('Enter a New Ticket ID')."</a></p>";					
						}							
					}

					// Show attendee and event information
						$output['otherdata'] = EVOQR()->checkin->get_other_event_data($RSVP, 'rsvp');

				}

			}else{ // invalid ticket ID
				$classes[] = 'no';
				$output['icon'] = 'bad';
				$output['msg'] = evo_lang('Invalid Ticket ID');
				
			}

			// process output
			$classes_str = (sizeof($classes)>0)? implode(' ', $classes):'';
			$output['classes'] = $classes_str;
			
			return apply_filters('evoqr_data_output', $output, $ticket_number, $id_type, $ticket_meta_data);
		}

	// Supporting functions
		function _views($type){

			$checking_page = EVOQR()->checkin->get_checking_page_url();
		
			switch($type){
				case 'notloggedin':
					$evo_login_link = EVO()->cal->get_prop('evo_login_link','evcal_1');
					$tixid = (!empty($_GET['id'])? $_GET['id']: null);

					$classes[] = 'no';
					$login_url = $evo_login_link? $evo_login_link: wp_login_url($checking_page . (!empty($tixid)? '?id='.$tixid:'') );

					$msg = evo_lang('Login required to checkin guests, please login');
					$msg .= sprintf("<p class='evomart20'><a href='%s' class='evcal_btn'>%s</a></p>", $login_url, evo_lang('Login Now') );
					?>
					<div class='evo_checkin_page no'>
						<?php $this->print_big_icon('bad');?>
						<h4><?php echo $msg;?></h4>
					</div>
					<?php
				break;
				case 'nopermissions':
					?><div class='evo_checkin_page no'>
					<?php $this->print_big_icon('bad');?>
					<h4><?php echo evo_lang_get('evoQR_007', 'You do not have permission!');?></h4>
					</div>
					<?php
				break;
				
				case 'noticket_id':
					

					?><div class='evo_checkin_page no typeid evoboxbb'>
					
					<h4><?php echo evo_lang('Check-in Guests');?></h4>
					<div class='evpqr_content'>
						<?php $this->_views('scanner_gun_js');?>
						<form action='<?php echo $checking_page;?>' method='GET'>
							<p class='evoqr_input_form evodfx evofxdrr evogap5'>
								<input class='another_id evofx1' type='text' name='id' placeholder='<?php echo evo_lang('Ticket ID');?>'/>
								<button class='evoqr_checkin_submit evcal_btn' type='submit' data-url='<?php echo $checking_page;?>'><?php echo evo_lang('Find Guest');?></button>
							</p>
						</form>
					</div>
					</div>
					<?php
				break;
				case 'invalid_ticket_id':

					?><div class='evo_checkin_page no'>
						<?php $this->print_big_icon('bad');?>
					<h4><?php echo evo_lang('This is an invalid ticket ID !');?></h4>
					<p><a class='btn' href='<?php echo $checking_page;?>'><?php evo_lang_e('Enter a New Ticket ID');?></a></p>
					</div>
					<?php
				break;
				case 'scanner_gun_js':
					if(EVO()->cal->get_prop('evoqr_mode','evcal_1')=='gun'):?>
						<script type="text/javascript">
							jQuery(document).ready(function($){
								INPUT = $('body').find('input.another_id');
								INPUT.focus();
								INPUT.on('keyup',function(){
									if( e.keyCode == 13 && INPUT.val() != ''){
										INPUT.siblings('button').trigger('click');
									}
								});
							});
						</script>
					<?php endif;

					// html5 web scanner
					if(EVO()->cal->get_prop('evoqr_mode','evcal_1')=='web'):
						echo '<div id="my-qr-reader" class="evobr10 evoff_2 evofz14 evomarb20 evo_of_h"></div>';
						wp_register_script( 'evoqr_html5_scanner', false ); // Register a dummy handle
	    				wp_enqueue_script( 'evoqr_html5_scanner' );
						wp_add_inline_script( 'evoqr_html5_scanner', file_get_contents( EVOQR()->assets_path . 'html5_qrscan.min.js' ) );
						?>
						<script>
						function domReady(fn) {
						    if (
						        document.readyState === "complete" ||
						        document.readyState === "interactive"
						    ) {
						        setTimeout(fn, 1000);
						    } else {
						        document.addEventListener("DOMContentLoaded", fn);
						    }
						}

						domReady(function () {

						    // If found you qr code
						    function onScanSuccess(decodeText, decodeResult) {
						        // Basic URL validation
							    if (decodeText.match(/^https?:\/\/[^\s$.?#].[^\s]*$/)) {
							    	htmlscanner.clear();
							        window.location.href = decodeText;
							    } else {
							        console.error("Scanned QR code is not a valid URL: " + decodeText);
							        alert("Error: The scanned QR code does not contain a valid Ticket ID.");
							    }
						    }

						    let htmlscanner = new Html5QrcodeScanner(
						        "my-qr-reader",
						        { fps: 10, qrbos: 250 }
						    );
						    htmlscanner.render(onScanSuccess);
						});
						</script>
						<?php

					endif;
				break;
			}
		}

		function print_big_icon($state='good'){
			//EVO_Debug($state);
			switch($state){
				case 'bad':
					echo "<p class='evoqr_big_icon'><i style='text-align:center;' class='fa fa-times'></i></p>";
				break;
				case 'exclaim':
					echo "<p class='evoqr_big_icon'><i style='text-align:center;' class='fa fa-exclamation'></i></p>";
				break;
				case 'good':
					echo "<p class='evoqr_big_icon'><i style='text-align:center;' class='fa fa-check'></i></p>";
				break;
				case 'unchecked':
					echo "<p class='evoqr_big_icon'><i style='text-align:center;' class='fa fa-xmark'></i></p>";
				break;
				case 'waitlist':
					echo "<p class='evoqr_big_icon'><i style='text-align:center;' class='fa fa-clipboard-check'></i></p>";
				break;
			} 
		}

} 