<?php
/** 
 * Integration with event tickets addon
 * @version 1.4.5
 */

class EVOBO_Tickets_Int{
	public function __construct(){
		// WC
			// ADD to cart
				add_filter('evotx_cart_session_item_values', array($this,'cart_session_item_data'), 10, 1 );
				add_filter('evotx_add_cart_item_meta', array($this, 'add_to_cart'),10,4);
				add_filter('evotx_ticket_added_cart_ajax_data', array($this, 'add_to_cart_ajax_return'),10,3);
				add_filter('evotx_ticket_item_price_for_cart', array($this, 'cart_ticket_price'),10,4);

			// Cart view
				add_filter('evotx_ticket_item_meta_data',array($this,'cart_ticket_meta_data'),1,3);
				add_filter('evotx_cart_item_quantity',array($this,'cart_item_quantity'),1,4);
				add_filter('evotx_cart_item_max_qty', array($this, 'WC_cart_item_maxqty'), 10, 3);

				add_action('evotix_cart_item_validation', array($this, 'cart_validation'), 10, 3);

			// checkout
				add_action('evotx_checkout_create_order_line_item',array($this,'order_item_meta_update_new'),1,4);
				add_action('evotx_cart_ticket_qty_zero',array($this,'update_removed_cart_items'),1,2);
				add_filter('evotx_adjust_orderitem_ticket_stockother', array($this, 'adjust_ticket_block_item_stock'), 10, 6);
				add_filter('evotx_order_item_meta_slug_replace', array($this, 'ticket_meta_slug_replace'),10,1);
				add_filter('evotx_tix_save_field_meta', array( $this, 'tix_meta_values'),10,2);
				add_filter('evotx_cart_add_field_eventtime', array( $this, 'tix_eventtime'),10,2);

				add_filter('woocommerce_order_item_get_formatted_meta_data', array( $this, 'order_item_meta_data'),10,2);


			// Emailing
				add_action('evotix_confirmation_email_additional_data', array($this, 'tix_confirmation_email_data'), 10, 5);
		
		// frontend template
			add_filter('evotx_single_product_temp', array($this, 'frontend_temp'), 10,2);
			add_filter('evotx_addtocart_text_strings', array($this, 'fe_text_strings'), 10,1);
			add_filter('evotx_get_attendees_for_event', array($this, 'view_attendees'), 10, 2);

		// ADMIN ONLY
		if(is_admin()){
			add_action('eventontx_tix_post_table', array($this, 'evo_tix_table_row'), 10, 2);
			
			add_filter('evotx_csv_headers', array($this, 'csv_headers'), 10, 2);
			add_filter('evotx_csv_row', array($this, 'csv_row'), 10, 4);
			//add_action('evotx_sales_insight_after', array($this, 'sales_insight'), 10, 2);
		}

		add_filter('evotx_hidden_order_itemmeta', array($this,'hide_order_item_metafields'),10,1);
	}

	// FRONTEND	
		function fe_text_strings( $arg){
			$arg['evobo1'] = evo_lang('Time Block successfully added to cart');
			return $arg;
		}	
		function frontend_temp($boolean, $event, $other_classes = ''){

			$BLOCKS = new EVOBO_Blocks( $event);

			if( !$BLOCKS->is_blocks_active()) return $boolean;

			$help = new evotx_helper();

			ob_start();
			
			$style = $event->get_prop('_evobo_style');
			if(!$style) $style = 'def';

			// get booking data
				$evobo_data = array();
				$evobo_data['evobo_json'] = $BLOCKS->get_frontend_block_json( false, false);
				$style = $event->get_prop('_evobo_style');

				if($style == 'slot'):
					$evobo_data['evobo_dataset'] = array(					
						'hide_end'=> $event->check_yn('_evobo_hide_end'),		
						'show_rem'=> $event->check_yn('_evobo_show_rem'),		
						't2'=> __( evo_lang('Select an available time slot')),
						't3'=> __( evo_lang('No available slots, please try another date!')),
						't3n'=> __( evo_lang('There are no available time slots at the moment!')),
						't5'=> __( evo_lang('Spaces left')),
						't5s'=> __( evo_lang('Space left')),
					);
				else:
					$lang = EVO()->lang;
					$current_time = current_time('timestamp');
					$EVO_Cal = new EVO_Calendar('evcal_2');

					$evobo_data['evobo_dataset'] = array(
						'sow'=> get_option('start_of_week'),
						'cty'=> date('Y',$current_time),
						'ctm'=> date('n',$current_time),
						'ctd'=> date('j',$current_time),
						'hide_end'=> $event->check_yn('_evobo_hide_end'),
						'show_rem'=> $event->check_yn('_evobo_show_rem'),
						'm'=> 	EVO()->cal->_get_all_month_names(),
						'df'=> 	EVO()->cal->get_all_day_names('full'),
						'd3'=> 	EVO()->cal->get_all_day_names('three'),
						'd1'=> 	EVO()->cal->get_all_day_names('one'),
						't1'=> __( evo_lang('Select a date')),
						't2'=> __( evo_lang('Select an available time slot')),
						't3'=> __( evo_lang('No available slots, please try another date!')),
						't3n'=> __( evo_lang('There are no available time slots at the moment!')),
						't4'=> __( evo_lang('Today')),
						't5'=> __( evo_lang('Spaces left')),
						't5s'=> __( evo_lang('Space left')),
					);
				endif;

			?>
			<div class='evobo_booking_section <?php echo $style;?> <?php echo $other_classes;?> tx_single' data-s='<?php echo $style;?>'>
				<div class='evobo_loading_section'>
					<div class='evo_loading_bar_holder h100'>
						<div class="evo_loading_bar hi_150"></div>
						<div class="evo_loading_bar hi_50"></div>
						<div class="evo_loading_bar wid_40 hi_50"></div>
					</div>
				</div>

				<div class='evobo_main_selection evotx_hidable_section'>					
					<?php if($style != 'slot'):?> <div class='evobo_calendar'></div><?php endif;?>
					<div class='evobo_selections'></div>					
				</div>
				<?php /* this is where price info & added to cart msg will go */?>
				<div class="evobo_price_values " style='display:none'></div>

				<?php 
				$help->print_select_data_element( array(
					'class'=>'evotx_other_data evobo',
					'data'=> array(
						'block_id'=>'',
					)
				) );
				?>
				<div class='evobo_data' <?php echo $help->array_to_html_data( $evobo_data );?>></div>	
			</div>

			<?php 
			$content = ob_get_clean();
			return $content;
		}

	// add to CART via AJAX
		function add_to_cart_ajax_return( $ajaxdata, $EVENT, $DATA){
			if( !isset($DATA)) return $ajaxdata;
			if( !isset($DATA['other_data'])) return $ajaxdata;
			if( !isset($DATA['other_data']['block_id'])) return $ajaxdata;

			$ajaxdata['msg'] = 'evobo1';
			return $ajaxdata;

		}
		function add_to_cart($cart_item_data, $EVENT, $def_price, $DATA){

			
			if( !isset($DATA['other_data'])) return $cart_item_data;
			if( !isset($DATA['other_data']['block_id'])) return $cart_item_data;

			$booking_index = $DATA['other_data']['block_id'];

			$BLOCKS = new EVOBO_Blocks( $EVENT, $EVENT->wcid );
			$BLOCKS->set_block_data($booking_index);

			// update block date and time format
				$DT = EVO()->calendar->get_date_time_format();
				$BLOCKS->date_format  = $DT['date_format'];
				$BLOCKS->time_format  = $DT['time_format'];

			$max_stock = $BLOCKS->get_item_prop('capacity')? (int)$BLOCKS->get_item_prop('capacity'): 0;

			if($max_stock != 0){
				$qty = (int)$DATA['qty'];

				if($qty <= $max_stock){
					$status = 'good';
					$cart_item_data['evobo_index'] = $booking_index;
					$cart_item_data['evobo_price'] = $BLOCKS->get_item_prop('price');	

					// get proper block time
						// if hide end time
						if( $BLOCKS->event->check_yn('_evobo_hide_end')){
							$block_time = $BLOCKS->get_block_time_string($booking_index, 'start');
						}else{
							$block_time = $BLOCKS->get_block_time_string($booking_index);
						}
						
						$cart_item_data['evobo_block_time'] = $block_time;

					// block duration
						if( $BLOCKS->event->check_yn('_evobo_show_dur')){
							$cart_item_data['evobo_block_duration'] = $BLOCKS->get_block_duration($booking_index);
						}
				}
			}

			return $cart_item_data;

		}
		function cart_session_item_data($array){
			$array[] = 'evobo_price';
			$array[] = 'evobo_index';
			$array[] = 'evobo_block_time';
			return $array;
		}
		function cart_ticket_price($boolean, $def_price, $session_data, $values){
			if (array_key_exists( 'evobo_price', $values ) ){
				return $values['evobo_price'];
	       		//$session_data['data']->set_price( $values['evobo_price'] );
	        }
	        return $boolean;
		}

	// CART VIEW
		function cart_ticket_meta_data($data, $values, $EVENT){
			if(isset($values['evobo_block_time'])){
				unset($data['event_time']); // get rid of the event time
				$data['block_data'] = array(evo_lang('Block Time'), $values['evobo_block_time']);
			}

			// block duration
			if(isset($values['evobo_block_duration'])){
				$data['block_dur'] = array(evo_lang('Duration'), $values['evobo_block_duration']);
			}
			return $data;
		}

		// WC REST cart item max qty @1.4.5
		function WC_cart_item_maxqty($max, $product, $cart_item){

			//print_r($cart_item);

			if(empty($cart_item['evobo_price']) ) return $max;

			// 1.4.5 moved to leave quantity uneditable at chart for better stock management
			return $cart_item['quantity'];

	   		$BLOCKS = new EVOBO_Blocks( $cart_item['evotx_event_id_wc'], $cart_item['product_id']);
	   		$block_stock = $BLOCKS->has_stock($cart_item['evobo_index']);
	   		
	   		return $block_stock? $block_stock: $cart_item['quantity'];
			return $max;
		}

		function cart_item_quantity($bool, $_product, $cart_item_key, $cart_item ){
			
			if(empty($cart_item['evobo_price']) ) return $bool;

			// 1.3.1 moved to leave quantity uneditable at chart for better stock management
			return $cart_item['quantity'];

			//print_r($cart_item);
	   		
	   		$BLOCKS = new EVOBO_Blocks( $cart_item['evotx_event_id_wc'], $cart_item['product_id']);
	   		$block_stock = $BLOCKS->has_stock($cart_item['evobo_index']);

	   		$product_quantity = woocommerce_quantity_input( array(
				'input_name'  => "cart[{$cart_item_key}][qty]",
				'input_value' => $cart_item['quantity'],
				'max_value'   => $block_stock? $block_stock: $cart_item['quantity'],
				'min_value'   => '0',
			), $_product, false );


	   		//return $block_stock? $block_stock: $cart_item['quantity'];

			return $product_quantity;   		
	   	}
	   	function cart_validation($cart_item_key, $cart_item, $event_id){
			if(!isset($cart_item['evobo_index']) ) return false;

			$_ticket_block_index = $cart_item['evobo_index'];

			$BLOCKS = new EVOBO_Blocks($event_id, $cart_item['product_id']);
				
			//$ticket_options_active = $this->fnc->is_ticket_options_active( $event_id);
			$stock_available = $BLOCKS->is_stock_available( $_ticket_block_index, $cart_item['quantity']);

			// if seat not available or ticket sale is not active
			if( !$stock_available){
				//WC()->cart->remove_cart_item($cart_item_key);
				//wc_add_notice( 'Ticket removed from cart, no longer available for sale!', 'error' );
			}
		}

	// CHECKOUT
		// add custom data as meta data to order item	    
			function order_item_meta_update_new($item, $cart_item_key, $values, $order){

				foreach( array(
					'evobo_block_time'=> 'Block-Time',
					'evobo_block_duration'=> 'Duration',
					'evobo_index'=> '_ticket_block_index',
				) as $k=>$v){
					if( isset($values[ $k ]) )
						$item->add_meta_data( $v , $values[ $k ],true);
				}
			}

		// remove custom data if item removed from cart
			function update_removed_cart_items($cart_item_key, $values){
		       	// remove block from cart
		    }

		// main stock adjustment based on order status @1.4.2			
		function adjust_ticket_block_item_stock($boolean, $EVENT, $order, $item_id, $item, $type){
			
    		$block_index = wc_get_order_item_meta($item_id ,'_ticket_block_index'); 

    		if(!$block_index) return $boolean;		

    		$blocks = new EVOBO_Blocks( $EVENT, $item['product_id']);	

    		// if reduce
    		if( $type == 'reduce'){

    			// check if block is still available
    			if( $blocks->is_stock_available( $block_index , (int)$item['qty'] ) ){

    				$blocks->adjust_stock( $block_index, $type, $item['quantity'] , $order );

    			// block has no stock
    			}else{
    				$order->update_status(
    					'pending',
    					 sprintf( __('Block %s no longer availble for sale.','evobo'), $block_index )
    				);    				
    			}

    		// restock
    		}else{ 
    			$blocks->adjust_stock($block_index, $type, $item['quantity'] , $order );
    		}

    		return true;   			    	
		}

		function ticket_meta_slug_replace($array){
			$array['Block-Time'] = evo_lang('Block Time');
			return $array;
		}

		// save ticket item meta custom values for faster retrieve of data
		function tix_meta_values($array, $item){
			if(!empty($item['Block-Time'])) $array['Block-Time'] = $item['Block-Time']; // @deprecating
			if(!empty($item['Block-Time'])) $array['_block_time'] = $item['Block-Time'];
			if(!empty($item['Duration'])) $array['_duration'] = $item['Duration'];
			if(!empty($item['_ticket_block_index'])) $array['_ticket_block_index'] = $item['_ticket_block_index'];

			return $array;
		}

		// event time field in the checkout under additional information
		function tix_eventtime($event_time, $values){

			// value check
			if(!isset($values['evotx_event_id_wc'])) return $event_time;
			if(!isset($values['evobo_index'])) return $event_time;
			if(!isset($values['product_id'])) return $event_time;

			//print_r($values);
			$event_id = $values['evotx_event_id_wc'];

			$evobo_index = $values['evobo_index'];

			$BLOCKS = new EVOBO_Blocks( $event_id, $values['product_id']);
			$BLOCKS->set_block_data( $evobo_index );

			return $BLOCKS->get_block_time_string();

		}

		// order item meta data returns
		function order_item_meta_data($array, $item){
			$new_array = $array;
			$remove_event_time = false;
			foreach($array as $keyid=>$meta){
				if($meta->key == 'Block-Time') $remove_event_time = true;
			}
			if($remove_event_time){
				foreach($array as $keyid=>$meta){
					if($meta->key == 'Event-Time'){
						unset($new_array[$keyid]);
					}
				}
			}
			return $new_array;
		}

	// ADMIN ONLY	
		// CSV download attendees
			function csv_headers($array, $EVENT){
				if( $EVENT->check_yn('_evobo_activate')){
					$array[]= 'Block Time';
				}
				return $array;
			}
			function csv_row($array, $tn, $td, $EVENT){
				if( $EVENT->check_yn('_evobo_activate') ){
					$array['block_time']= isset($td['oD']['block_time'])? '"'.$td['oD']['block_time'].'"':'';
				}
				return $array;
			}

		// show ticket booking information for evo-tix cpt
		function evo_tix_table_row($post_id, $ticketItem_meta){

			foreach( array(
				'_block_time'=> evo_lang('Booking Slot Time'),
				'_duration'=> evo_lang('Duration'),
			) as $k=>$v){

				if(!empty($ticketItem_meta[ $k ])): ?>
			
				<tr><td><?php echo $v;?>: </td>
				<td><?php echo $ticketItem_meta[ $k ][0];?></td></tr>

			<?php endif;
			}				
		}

		function view_attendees($array, $event_id){

			if(!isset($array['id'])) return $array;
			$evo_tix_id = $array['id'];

			$TIX = new EVO_Ticket( $evo_tix_id );

			$BT = $TIX->get_meta( 'Block-Time');
			$dur = $TIX->get_meta( '_duration');
			
			if(!$BT) return $array;

			$array['oD']['block_time'] = $BT;
			if($dur) $array['oD']['duration'] = $dur;
			unset($array['oD']['event_time']);

			$bi = $TIX->get_meta( '_ticket_block_index');
			
			if($bi) $array['oDD']['block_index'] = $bi;
			return $array;

		}
		function hide_order_item_metafields($array){
			$array[] = '_ticket_block_index';
			$array[] = '_block_time';
			$array[] = '_duration';
			return $array;
		}

		// sales insight
			function sales_insight($EVENT, $orders){
				?>
				<div class='evotxsi_row sales_by_booking_slots'>
					<h2><?php _e('Sales by booking slots','evotx');?></h2>	
					<h3><?php _e('Top 3 countries where customers have placed orders from','evotx');?></h3>	
				</div>
				
				<?php
			}

	// Show booking information for confirmation ticket email
		public function tix_confirmation_email_data($TIX, $EVENT,$styles, $ticket_number, $tix_holder_index){

			foreach( array(
				'_block_time'=> evo_lang('Block Information'),
				'_duration'=> evo_lang('Duration'),
			) as $k=>$v){
				
				if(!empty($TIX->get_prop( $k ) ) ): ?>
					<div>
					<p style="<?php echo $styles['005'].$styles['pb5'].$styles['pt10'];?>"><?php echo $TIX->get_prop( $k ); ?></p>
					<p style="<?php echo $styles['004'].$styles['pb5'];?>"><?php echo $v;?></p>
				</div>
				<?php endif;
			}

		}
		
}