<?php 
/** 
 * Bookings Post Meta Boxes
 * @version 1.4.5
 */

class evobo_meta_boxes{
	public function __construct(){
		add_action('evotx_event_metabox_end',array($this, 'event_tickets_metabox'), 10, 5);
		add_filter('evotx_save_eventedit_page',array($this, 'event_ticket_save'), 10, 1);
		add_filter('evotx_after_saving_ticket_data',array($this, 'after_main_save'), 10, 1);

		add_filter('evost_before_tickets_meta_box', array($this, 'event_ticket_metabox_before'),10, 2);
	}

	// disable seats if booking blocks are enabled
	function event_ticket_metabox_before($boolean, $EVENT){
		
		if($EVENT->get_prop('_evobo_activate') == 'yes')	return __('Seats can not be enabled while booking blocks are enabled for this event!','evobo');
		return $boolean;
	}
	function event_tickets_metabox($eventid, $epmv, $wooproduct_id, $product_type, $EVENT){
		
		echo "<div class='evopad10 evo_borderb'>";

		// only for simple, non-repeating - events
			if($product_type != 'simple'):
				?>
				<p><i><?php _e('NOTE: Event Bookings are only available for simple ticket product with no 	repeat instances at the moment. The event ticket basic information must be saved first before adding Bookings.', 'evobo'); ?></i></p>			
				<?php
				return false;
			endif;
		

		// repeating event
			if($EVENT->is_repeating_event()){
				?>
				<div class='evopad20 evo_borderb'>
					<p><i><?php _e('NOTE: Booking blocks does not support repeating events!', 'evobo'); ?></i></p>
				</div>
				<?php
				return false;
			}

		if($product_type == 'simple' && !empty($wooproduct_id) && !$EVENT->check_yn('_manage_repeat_cap')):

		$__woo_currencySYM = get_woocommerce_currency_symbol();

		$BLOCKS = new EVOBO_Blocks($EVENT, $wooproduct_id);


			EVO()->elements->_print_settings_toggle_nester_start(array(
				'id'=>'_evobo_activate',
				'value'=>$EVENT->get_prop('_evobo_activate'),
				'value_yn'=> $EVENT->check_yn('_evobo_activate'),
				'afterstatement'=>'evobo_section',			
				'tooltip'=>__('This will allow you to sell tickets by time blocks.','evobo'),
				'label'=> __('Enable booking blocks for this ticket','evobo'),
			));
		
			
				echo "<div class='evomarb20'>";
				EVO()->elements->get_element(array(
					'type'=>'detailed_button', '_echo'=> true,
					'name'=>__('Booking Block Manager','evobo'),
					'description'=>__('Configure Booking Blocks for this Event','evobo'),
					'field_after_content'=> "Configure",
					'trig_data'=> array(
						'uid'=>'evobo_manager',
						'lb_class' =>'evobo_lightbox',
						'lb_padding' =>'evopad0',
						'lb_title'=>__('Booking Block Manager','eventon'),	
						'ajax_data'=>array(					
							'eid'=> $EVENT->ID,
							'wcid'=> $wooproduct_id,
							'action'=> 'evobo_load_editor',
						),
					),
				));
				echo "</div>";

				$V = $EVENT->get_prop('_evobo_style');

				echo EVO()->elements->process_multiple_elements(
					array(
						array(
							'row_class'=>'evobo_style',
							'styles'=>'',
							'type'=>'select_row',
							'name'=>'_evobo_style',
							'value'=> ($V? $V: 'def'),
							'label'=> __('Booking display style','evobo'),
							'options'=>array(
								'def'=> __('Calendar View', 'evobo'),
								'slot'=> __('Time Slot View', 'evobo'),
							)
						),
						array(
							'type'=>'yesno_btn',
							'id'=>'_evobo_hide_end',
							'name'=>'_evobo_hide_end',
							'label'=> __('Hide all booking block end time','evobo'),
							'value'=> $EVENT->get_prop('_evobo_hide_end'),
							
						),
						array(
							'type'=>'yesno_btn',
							'id'=>'_evobo_show_dur',
							'name'=>'_evobo_show_dur',
							'label'=> __('Show booking block duration','evobo'),
							'tooltip'=> __('This will show block duration once a time slot is selected.','evobo'),
							'value'=> $EVENT->get_prop('_evobo_show_dur'),
							
						),
						array(
							'type'=>'yesno_btn',
							'id'=>'_evobo_show_rem',
							'name'=>'_evobo_show_rem',
							'label'=> __('Show remaining count','evobo'),
							'tooltip'=> __('This will show the remaining space for each block.','evobo'),
							'value'=> $EVENT->get_prop('_evobo_show_rem'),
							
						)
					)
				);

				do_action('evobo_after_event_settings',$BLOCKS);

			EVO()->elements->_print_settings_toggle_nester_close();
					

		endif;

		echo "</div>";
	}

	// get time format
		function get_time_format(){
			$wp_time_format = get_option('time_format');
			return (strpos($wp_time_format, 'H')!==false || strpos($wp_time_format, 'G')!==false)? 'H:i':'h:i:A';
		}

	// save fields
		function event_ticket_save($array){
			$array[] = '_evobo_activate';
			return $array;
		}
		// save block capacities to sync with ticket data
		function after_main_save($event_id){
			
		}
}
new evobo_meta_boxes();