<?php
/**
 * Admin
 * @version 1.4.2
 */
class evobo_admin{
	public function __construct(){
		add_action('admin_init', array($this, 'admin_init'));		
	}

	function admin_init(){
		include_once('class-post_meta.php');
		include_once('class-admin_editor.php');

		add_action('eventon_admin_post_script',array($this, 'event_post_styles'));

		if(defined('DOING_AJAX')){	
			include_once( 'class-admin-ajax.php' );		
		}		

		// eventon
		add_filter('evo_addons_details_list',array($this, 'addon_list'),10,1);
		//add_filter( 'evotix_settings_page_content', array( $this, 'settings_tix' ),10,1);

	}
	
	// styles and scripts
		function event_post_styles(){			
			wp_enqueue_style( 'evobo_admin_styles',EVOBO()->assets_path.'evobo_admin_styles.css', '', 
				EVOBO()->version);
			wp_enqueue_script( 'evobo_admin_post_script',EVOBO()->assets_path.'evobo_admin_script.js',
				array('jquery','jquery-ui-draggable','jquery-ui-sortable'), EVOBO()->version);
			wp_localize_script( 
				'evobo_admin_post_script', 
				'evobo_admin_ajax_script', 
				array( 
					'ajaxurl' => admin_url( 'admin-ajax.php' ) , 
					'postnonce' => wp_create_nonce( 'eventonbo_nonce' )
				)
			);
		}

	
	// settings
		function settings_tix($array){
			$array[] = array(
				'id'=>'evotxbo',
				'name'=>'Booking Settings For EventON Ticket',
				'tab_name'=>'Booking Settings',
				'icon'=>'calendar',
				'fields'=>array(
					array(
						'id'=>'evobo_display_style',
						'type'=>'dropdown',
						'name'=>'Time slot booking style on eventcard',
						'legend'=>'Select the layout style for how you want the booking to show on frontend.',
						'options'=>array(
							'def'=>'Default',
							'sty1'=>'Separated times',
						),
					)
			));
			return $array;
		}

	// eventon
		function addon_list($array){
			$array['eventon-bookings'] = array(
				'id'=>'EVOBO',
				'name'=>'Bookings',
				'link'=>'http://www.myeventon.com/addons/bookings',
				'download'=>'http://www.myeventon.com/addons/bookings',
				'desc'=>'Sell event tickets as time slot based bookings or appointments'
			);

			return $array;
		}

}