<?php
/**
 * @package   Fat_Portfolio
 * @author    roninwp <kenus.ronin@gmail.com>
 * @copyright 2016 RoninWP
 */

$image_thumbnails = array();
$img_col = 'fat-col-md-8';
$has_right_col = (count($portfolio_attributes) > 0 && isset($portfolio_attributes['value_attribute'][0]) && $portfolio_attributes['value_attribute'][0] != '') || get_the_excerpt() != '';
$img_col = $has_right_col ? $img_col : 'fat-col-md-12';
?>
<div class="fat-portfolio-main-detail">
    <div class="fat-row">
        <div class="<?php echo esc_attr($img_col); ?> fat-col-sm-12 fat-col-xs-12 image-gallery">
            <?php
            $image_gallery_template = FAT_PORTFOLIO_DIR_PATH . "/templates/single/image-gallery-$media_source.php";
            if (file_exists($image_gallery_template)) {
                include_once $image_gallery_template;
            }
            ?>
        </div>

        <?php if ($has_right_col) : ?>
            <div class="fat-col-md-4  fat-col-sm-12 fat-col-xs-12">
                <div class="portfolio-info-label">
                    <span><?php echo esc_html($project_info_label); ?></span>
                </div>
                <div class="attribute-container">
                    <?php if ($cat): ?>
                        <div class="attr-item">
                            <span class="attr-title"><?php echo esc_html($single_category_label); ?> : </span>
                            <span class="attr-value"><?php echo wp_kses_post($cat); ?> </span>
                        </div>
                    <?php endif; ?>

                    <?php
                    $attribute_template = FAT_PORTFOLIO_DIR_PATH . "/templates/single/attribute.php";
                    if (file_exists($attribute_template)) {
                        include_once $attribute_template;
                    }
                    ?>

                    <?php if(isset($tags) && is_array($tags)){ ?>
                        <div class="portfolio-info-box">
                            <h6 class="p-font"><?php echo esc_html__('Tag','fat-portfolio') ?> </h6>
                            <div class="portfolio-tags">
                                <?php foreach($tags as $tag){ ?>
                                    <a href="<?php echo esc_url(get_tag_link($tag->term_id )) ?>">
                                            <span class="tag">
                                                <?php echo wp_kses_post($tag->name) ?>
                                            </span>
                                    </a>
                                <?php } ?>
                            </div>
                        </div>
                    <?php } ?>

                </div>
                <div class="excerpt-container">
                    <div class="excerpt-label"><?php echo esc_html($project_detail_label); ?></div>
                    <div class="excerpt-detail">
                        <?php
                        if($is_extra_excerpt){
                            $excerpt = apply_filters( 'the_content', $excerpt );
                            echo str_replace( ']]>', ']]&gt;', $excerpt );
                        }else{
                            the_excerpt();
                        }
                        ?>
                    </div>
                </div>
                <?php
                $share_template = FAT_PORTFOLIO_DIR_PATH . "/templates/single/social-share.php";
                if (file_exists($share_template)) {
                    include_once $share_template;
                }
                ?>
            </div>
        <?php endif; ?>
    </div>
    <?php if ($content_exists): ?>
        <div class="fat-row">
            <div class="fat-col-md-12 detail-container">
                <div class="portfolio-detail-label"><?php echo esc_html($more_detail_label); ?></div>
                <div class="portfolio-detail">
                    <?php the_content() ?>
                </div>
            </div>
        </div>
    <?php endif; ?>
</div>