<?php
if (!defined('_PS_VERSION_'))
{
	exit;
}
class Scpsseatreservation extends Module{
	public function __construct(){
		$this->name = 'scpsseatreservation';
		$this->tab = 'administration';
		$this->version = '1.0.0';
		$this->author = 'SmartCms Team';
		$this->need_instance = 0;
		$this->ps_versions_compliancy = array('min' => '1.5', 'max' => _PS_VERSION_);
		$this->controllers = array("cauhinh");
		$this->bootstrap = true;

		parent::__construct();

		$this->displayName = $this->l('Seat Reservation');
		$this->description = $this->l('Allow manage seats booking.');

		$this->confirmUninstall = $this->l('Are you sure you want to uninstall?');

		if (!Configuration::get('scpsseatreservation'))
			$this->warning = $this->l('No name provided');
	}
	public function install(){
		$tab = new Tab;
        $tab->class_name = "ScpsSeatReservationCauhinh";
        $tab->module = $this->name;
        $tab->name[$this->context->language->id] = $this->l('Seat Reservation');
        $tab->id_parent = (int)Tab::getIdFromClassName('Configure');
        $tab->add();

        if (!parent::install()  || !$this->_createTabels())
            return false;
		$this->registerHook('displayBackOfficeHeader');
		$this->registerHook('displayAdminProductsExtra');
		$this->registerHook('displayProductAdditionalInfo');
		$this->registerHook('displayHeader');
		$this->registerHook('displayShoppingCart');
		$this->registerHook('displayOrderConfirmation');

        return true;
	}
	public function hookDisplayBackOfficeHeader()
	{
		$controller_name = Tools::getValue('controller');
		if($controller_name == "ScpsSeatReservationCauhinh"){
			$this->context->controller->addCSS('https://maxcdn.bootstrapcdn.com/font-awesome/4.6.1/css/font-awesome.min.css', 'all');
			$this->context->controller->addCSS($this->_path.'views/css/config.css', 'all');
			$this->context->controller->addJS($this->_path.'views/js/config.js', 'all');
			
			$this->context->controller->addCSS('http://code.jquery.com/ui/1.11.2/themes/smoothness/jquery-ui.css', 'all');
			$this->context->controller->addJS('https://code.jquery.com/ui/1.11.2/jquery-ui.js', 'all');
			$this->context->controller->addCSS($this->_path.'views/css/jquery-ui-timepicker-addon.css', 'all');
			$this->context->controller->addJS($this->_path.'views/js/jquery-ui-timepicker-addon.js', 'all');
		}elseif($controller_name == "AdminProducts"){
			$this->context->controller->addCSS('https://maxcdn.bootstrapcdn.com/font-awesome/4.6.1/css/font-awesome.min.css', 'all');
			$this->context->controller->addCSS($this->_path.'views/css/admin.css', 'all');
			
			$this->context->controller->addJS($this->_path.'views/js/admin.js', 'all');
		}
	}
	public function hookDisplayHeader(){
		$controller_name = Tools::getValue('controller');
		if($controller_name == "product"){
			$this->context->controller->addCSS($this->_path.'views/css/product.css', 'all');
			$this->context->controller->addJS($this->_path.'views/js/product.js', 'all');
		}elseif($controller_name == "cart" || $controller_name == "orderconfirmation"){
			$this->context->controller->addCSS($this->_path.'views/css/cart.css', 'all');
		}
	}
	public function hookDisplayAdminProductsExtra($params){
		$profilesSql = 'SELECT * FROM '._DB_PREFIX_.'scpsasrm_profiles';
		$profiles = Db::getInstance()->ExecuteS($profilesSql);
		
		$this->context->smarty->assign(array(
			'id_product' => $params['id_product'],
			'profiles' => $profiles,
			'dbprefix' => _DB_PREFIX_,
			'siteurl' => _PS_BASE_URL_.__PS_BASE_URI__
		));
        return $this->display(__FILE__, 'views/templates/admin/scpsasrmExtraTab.tpl');
    }
	public function hookDisplayProductAdditionalInfo($params){
		if( isset($_SESSION["seats".Tools::getValue('id_product')]) )
			$seatdata = $_SESSION["seats".Tools::getValue('id_product')];
		else
			$seatdata = "";
		
		if( isset($_SESSION["schedule".Tools::getValue('id_product')]) )
			$schedata = $_SESSION["schedule".Tools::getValue('id_product')];
		else
			$schedata = "";
		
		$this->context->smarty->assign(array(
			'id_product' => Tools::getValue('id_product'),
			'dbprefix' => _DB_PREFIX_,
			'siteurl' => _PS_BASE_URL_.__PS_BASE_URI__,
			'secdata' => $seatdata,
			'schedata' => $schedata
		));
		return $this->display(__FILE__, 'views/templates/front/productDetail.tpl');
	}
	public function hookDisplayShoppingCart($params){
		$this->id_cart = $this->context->cart->id;
		$cart = new Cart($this->id_cart);
		
		global $cookie;
		$currency = new CurrencyCore($cookie->id_currency);
		$my_currency_iso_code = $currency->sign;
		//echo "<pre>".print_r($_SESSION,1)."</pre>";
		$products = $cart->getProducts();
		$this->context->smarty->assign(array(
			'products' => $products,
			'secs' => $_SESSION,
			'dbprefix' => _DB_PREFIX_,
			'isocode' => $my_currency_iso_code
		));
		return $this->display(__FILE__, 'views/templates/front/cart.tpl');
	}
	public function hookDisplayOrderConfirmation($params){
		$order = $params['order'];
		$id_order = $order->id;
		$id_cart = $order->id_cart;
		
		$cart = new Cart($id_cart);
		$products = $cart->getProducts();
		
		global $cookie;
		$currency = new CurrencyCore($cookie->id_currency);
		$my_currency_iso_code = $currency->sign;
		
		$this->context->smarty->assign(array(
			'products' => $products,
			'secs' => $_SESSION,
			'dbprefix' => _DB_PREFIX_,
			'isocode' => $my_currency_iso_code,
			'orderId' => $id_order
		));
		
		return $this->display(__FILE__, 'views/templates/front/order.tpl');
	}
	public function uninstall(){
		$tab = new Tab((int)Tab::getIdFromClassName('ScpsSeatReservationCauhinh'));
        $tab->delete();

        // Uninstall Module
        if (!parent::uninstall())
            return false;
        return true;
	}
	private function _createTabels(){
		$sql = 'CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'scpsasrm_profiles` (
		`id` int(10) NOT NULL AUTO_INCREMENT,
		`profileName` varchar(255) NOT NULL,
		`mapcolumn` varchar(255) NOT NULL,
		`maprow` varchar(255) NOT NULL,
		PRIMARY KEY (`id`)
		) ENGINE='._MYSQL_ENGINE_.' DEFAULT CHARSET=utf8;';
		Db::getInstance()->execute($sql);
		
		$sql2 = 'CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'scpsasrm_profiles_mapping` (
		`id` int(10) NOT NULL AUTO_INCREMENT,
		`profileId` int(11) NOT NULL,
		`mapcolumn` varchar(255) NOT NULL,
		`maprow` varchar(255) NOT NULL,
		`type` varchar(255) NOT NULL,
		PRIMARY KEY (`id`)
		) ENGINE='._MYSQL_ENGINE_.' DEFAULT CHARSET=utf8;';
		Db::getInstance()->execute($sql2);
		
		$sql3 = 'CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'scpsasrm_seats` (
		`id` int(10) NOT NULL AUTO_INCREMENT,
		`profileId` int(11) NOT NULL,
		`seatLabel` varchar(255) NOT NULL,
		`seatColor` varchar(255) NOT NULL,
		`isbooked` varchar(255) NOT NULL,
		PRIMARY KEY (`id`)
		) ENGINE='._MYSQL_ENGINE_.' DEFAULT CHARSET=utf8;';
		Db::getInstance()->execute($sql3);
		
		$sql4 = 'CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'scpsasrm_schedule` (
		`id` int(10) NOT NULL AUTO_INCREMENT,
		`proId` int(11) NOT NULL,
		`schedule` varchar(255) NOT NULL,
		PRIMARY KEY (`id`)
		) ENGINE='._MYSQL_ENGINE_.' DEFAULT CHARSET=utf8;';
		Db::getInstance()->execute($sql4);
		
		$sql5 = 'CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'scpsasrm_product` (
		`id` int(10) NOT NULL AUTO_INCREMENT,
		`proId` int(11) NOT NULL,
		`profileId` int(11) NOT NULL,
		PRIMARY KEY (`id`)
		) ENGINE='._MYSQL_ENGINE_.' DEFAULT CHARSET=utf8;';
		Db::getInstance()->execute($sql5);
		
		$sql6 = 'CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'scpsasrm_seat_price` (
		`id` int(10) NOT NULL AUTO_INCREMENT,
		`proId` int(11) NOT NULL,
		`profileId` int(11) NOT NULL,
		`type` varchar(255) NOT NULL,
		`price` int(11) NOT NULL,
		PRIMARY KEY (`id`)
		) ENGINE='._MYSQL_ENGINE_.' DEFAULT CHARSET=utf8;';
		Db::getInstance()->execute($sql6);
		
		$sql7 = 'CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'scpsasrm_order` (
		`id` int(10) NOT NULL AUTO_INCREMENT,
		`proId` int(11) NOT NULL,
		`orderId` varchar(255) NOT NULL,
		`seat` varchar(255) NOT NULL,
		`schedule` varchar(255) NOT NULL,
		PRIMARY KEY (`id`)
		) ENGINE='._MYSQL_ENGINE_.' DEFAULT CHARSET=utf8;';
		Db::getInstance()->execute($sql7);
		
		return true;
	}
}