<?php
/**
 * Eventbrite Settings Page
 *
 * @author MoMo Themes
 */

$eb_private_token                = isset( $mmt_eo_exim_options['eb_private_token'] ) ? $mmt_eo_exim_options['eb_private_token'] : '';
$eb_imports_assign_category      = isset( $mmt_eo_exim_options['eb_imports_assign_category'] ) ? $mmt_eo_exim_options['eb_imports_assign_category'] : '';
$eb_imports_category_1           = isset( $mmt_eo_exim_options['eb_imports_category_1'] ) ? $mmt_eo_exim_options['eb_imports_category_1'] : '';
$eb_imports_category_2           = isset( $mmt_eo_exim_options['eb_imports_category_2'] ) ? $mmt_eo_exim_options['eb_imports_category_2'] : '';
$eb_imports_enable_repeat        = isset( $mmt_eo_exim_options['eb_imports_enable_repeat'] ) ? $mmt_eo_exim_options['eb_imports_enable_repeat'] : '';
$eb_export_organizer             = isset( $mmt_eo_exim_options['eb_export_organizer'] ) ? $mmt_eo_exim_options['eb_export_organizer'] : '';
$eb_exports_enable_custom_repeat = isset( $mmt_eo_exim_options['eb_exports_enable_custom_repeat'] ) ? $mmt_eo_exim_options['eb_exports_enable_custom_repeat'] : '';
$eb_default_currency             = isset( $mmt_eo_exim_options['eb_default_currency'] ) ? $mmt_eo_exim_options['eb_default_currency'] : '';

$et1     = 'event_type';
$ett1    = get_terms( $et1, array( 'hide_empty' => false ) );
$et2     = 'event_type_2';
$ett2    = get_terms( $et2, array( 'hide_empty' => false ) );
$ett1arr = array();
$ett2arr = array();

$tax_names_array = evo_get_ettNames( get_option( 'evcal_options_evcal_1' ) );
$et1_name        = $tax_names_array[1];
$et2_name        = $tax_names_array[2];
if ( ! empty( $ett1 ) && ! is_wp_error( $ett1 ) ) {
	foreach ( $ett1 as $ettterm ) {
		$ett1arr[ $ettterm->slug ] = $ettterm->name;
	}
}
if ( ! empty( $ett2 ) && ! is_wp_error( $ett2 ) ) {
	foreach ( $ett2 as $ettterm ) {
		$ett2arr[ $ettterm->slug ] = $ettterm->name;
	}
}
$org_list = array();
$org_list = $mmt_eo_exim->fn->mmt_eo_exim_eb_org_list();
$currency = new MMT_EO_ExIm_Currency_List();
?>
<div class="mmt-eo-ei-admin-content-box">
	<div class="mmt-eo-ei-admin-content-header">
		<h3><?php esc_html_e( 'Eventbrite Settings', 'mmt-eo-exim' ); ?></h3>
	</div>
	<div class="mmt-ms-admin-content-main" id="mmt-eo-ei-eventbrite-settings-form">
		<div class="mmt-eo-ei-section block-eventid">
			<div class="mmt-eo-ei-block">
				<label class="regular inline"><?php esc_html_e( 'Eventbrite Private Token:', 'mmt-eo-exim' ); ?></label>
				<input type="text" class="inline" name="eb_private_token" value="<?php echo esc_html( $eb_private_token ); ?>"/>
			</div>
			<div class="mmt-eo-ei-block">
				<span class="mmt-eo-ei-note">
				<?php
				echo wp_kses(
					sprintf(/* translators: %s: eventbrite api-keys url */
						esc_html__( 'Note: For private token, Log in to your Eventbrite account and visit your <a href="%s">API Keys page</a>.', 'mmt-eo-exim' ),
						'https://www.eventbrite.com/platform/api-keys'
					),
					array(
						'a' => array(
							'href' => array(),
						),
					)
				);
				?>
				</span>
			</div>
		</div>
		<div class="mmt-eo-ei-section">
			<div class="mmt-eo-ei-section-header">
				<?php esc_html_e( 'Eventbrite Import Settings', 'mmt-eo-exim' ); ?>
			</div>
			<div class="mmt-eo-ei-admin-block">
				<span class="mmt-eo-ei-admin-toggle-container" afteryes="eb_imports_assign_category">
					<label class="switch">
					<?php $checked = ( 'on' === $eb_imports_assign_category ) ? 'checked' : ''; ?>
						<input type="checkbox" class="switch-input" name="eb_imports_assign_category" <?php echo esc_html( $checked ); ?>>
						<span class="switch-label" data-on="Yes" data-off="No"></span>
						<span class="switch-handle"></span>
					</label>
				</span>
				<span class="mmt-eo-ei-toggle-container-label">
					<?php esc_html_e( 'Assign Default Category for imported Events.', 'mmt-eo-exim' ); ?>
				</span>
				<div id="eb_imports_assign_category" class="afteryes">
					<div class="mmt-eo-ei-block">
						<label class="regular inline">
							<?php
							echo esc_html(
								sprintf(/* translators: %s: category name */
									esc_html__( 'Select default %s term', 'mmt-eo-exim' ),
									$et1_name
								)
							);
							?>
						</label>
						<select class="inline" name="eb_imports_category_1">
							<?php
							foreach ( $ett1arr as $slug => $name ) :
								$selected = ( $eb_imports_category_1 === $slug ) ? 'selected' : '';
								?>
								<option value="<?php echo esc_attr( $slug ); ?>" <?php echo esc_attr( $selected ); ?>><?php echo esc_html( $name ); ?></option>
								<?php
							endforeach;
							?>
						</select>
					</div>
					<div class="mmt-eo-ei-block">
						<label class="regular inline">
							<?php
							echo esc_html(
								sprintf(/* translators: %s: category name */
									esc_html__( 'Select default %s term', 'mmt-eo-exim' ),
									$et2_name
								)
							);
							?>
						</label>
						<select class="inline" name="eb_imports_category_2">
							<?php
							foreach ( $ett2arr as $slug => $name ) :
								$selected = ( $eb_imports_category_2 === $slug ) ? 'selected' : '';
								?>
								<option value="<?php echo esc_attr( $slug ); ?>" <?php echo esc_attr( $selected ); ?>><?php echo esc_html( $name ); ?></option>
								<?php
							endforeach;
							?>
						</select>
					</div>
				</div>
			</div>
			<div class="mmt-eo-ei-admin-block">
				<span class="mmt-eo-ei-admin-toggle-container">
					<label class="switch">
					<?php $checked = ( 'on' === $eb_imports_enable_repeat ) ? 'checked' : ''; ?>
						<input type="checkbox" class="switch-input" name="eb_imports_enable_repeat" <?php echo esc_html( $checked ); ?>>
						<span class="switch-label" data-on="Yes" data-off="No"></span>
						<span class="switch-handle"></span>
					</label>
				</span>
				<span class="mmt-eo-ei-toggle-container-label">
					<?php esc_html_e( 'Import event series as repeat events on EventON.', 'mmt-eo-exim' ); ?>
				</span>
			</div>
		</div>
		<div class="mmt-eo-ei-section">
			<div class="mmt-eo-ei-section-header">
				<?php esc_html_e( 'Eventbrite Export Settings', 'mmt-eo-exim' ); ?>
			</div>
			<div class="mmt-eo-ei-block">
				<div class="mmt-eo-ei-admin-block">
					<span class="mmt-eo-ei-note">
						<?php esc_html_e( 'Please save your Private token before selecting organization. Organization dropdown will only be populated after you save your private token.', 'mmt-eo-exim' ); ?>
					</span>
				</div>
				<div class="mmt-eo-ei-admin-block">
					<label class="regular inline">
						<?php
						esc_html_e( 'Select organization list', 'mmt-eo-exim' );
						?>
					</label>
					<select class="inline" name="eb_export_organizer">
						<?php
						foreach ( $org_list as $slug => $name ) :
							$selected = ( $eb_export_organizer === $slug ) ? 'selected' : '';
							?>
							<option value="<?php echo esc_attr( $slug ); ?>" <?php echo esc_attr( $selected ); ?>><?php echo esc_html( $name ); ?></option>
							<?php
						endforeach;
						?>
					</select>
				</div>
				<div class="mmt-eo-ei-admin-block">
					<span class="mmt-eo-ei-admin-toggle-container">
						<label class="switch">
						<?php $checked = ( 'on' === $eb_imports_enable_repeat ) ? 'checked' : ''; ?>
							<input type="checkbox" class="switch-input" name="eb_exports_enable_custom_repeat" <?php echo esc_html( $checked ); ?>>
							<span class="switch-label" data-on="Yes" data-off="No"></span>
							<span class="switch-handle"></span>
						</label>
					</span>
					<span class="mmt-eo-ei-toggle-container-label">
						<?php esc_html_e( 'Create custom repeat(s) as a seperate event, all other recurrence will be exported as series.', 'mmt-eo-exim' ); ?>
					</span>
				</div>
				<div class="mmt-eo-ei-admin-block">
					<span class="mmt-eo-ei-note">
						<?php esc_html_e( 'All other EventON repeat type will be exported as Eventbrite series.', 'mmt-eo-exim' ); ?>
					</span>
				</div>
				<div class="mmt-eo-ei-admin-block">
					<label class="regular inline">
						<?php
						esc_html_e( 'Select default currency while exporting event', 'mmt-eo-exim' );
						?>
					</label>
					<select class="inline" name="eb_default_currency">
						<?php
						foreach ( $currency->clist as $slug => $name ) :
							$selected = ( $eb_default_currency === $slug ) ? 'selected' : '';
							?>
							<option value="<?php echo esc_attr( $slug ); ?>" <?php echo esc_attr( $selected ); ?>><?php echo esc_html( $name ); ?></option>
							<?php
						endforeach;
						?>
					</select>
				</div>
				<div class="mmt-eo-ei-admin-block">
					<span class="mmt-eo-ei-note">
						<?php esc_html_e( 'Please select your timezone city before exporting your event. Only future events will be exported to eventbrite.', 'mmt-eo-exim' ); ?>
					</span>
				</div>
			</div>
		</div>
	</div>
	<a href="#" class="mmt_eo_exim_btn_primary mmt_eo_exim_save_sttings" data-by="venue_id">
		<?php esc_html_e( 'Save Settings', 'mmt-eo-exim' ); ?>
	</a>
</div>
