<?php
/**
 * Eventbrite Import Page
 *
 * @author MoMo Themes
 */
?>
<div class="mmt-eo-ei-admin-content-box">
	<div class="mmt-eo-ei-admin-content-header">
		<h3><?php esc_html_e( 'Import', 'mmt-eo-exim' ); ?></h3>
	</div>
	<div class="mmt-eo-exim-admin-content-main eb_imports_main_block" id="mmt-eo-ei-eventbrite-import-form">
		<div class="eb_imports_msg_block"></div>
		<div class="mmt-eo-ei-admin-block">
			<p>
				<label class="regular inline">
					<?php
					esc_html_e( 'Import Event(s) by ', 'mmt-eo-exim' );
					?>
				</label>
				<select class="inline" name="eb_imports_import_by">
					<option value="event_id"><?php esc_html_e( 'Event ID', 'mmt-eo-exim' ); ?></option>
					<option value="organizer_id"><?php esc_html_e( 'Organization ID', 'mmt-eo-exim' ); ?></option>
					<option value="venue_id"><?php esc_html_e( 'Venue ID', 'mmt-eo-exim' ); ?></option>
				</select>
			</p>
		</div>
		<div class="mmt-eo-exim-option-block show" id="by_event_id">
			<div class="mmt-eo-ei-block">
				<label class="regular inline"><?php esc_html_e( 'Event ID', 'mmt-eo-exim' ); ?></label>
				<input type="text" class="inline" name="eb_imports_by_event_id_eid"/>
			</div>
			<em class="hr_line"></em>
			<div class="mmt-eo-ei-block">
				<span class="mmt-eo-ei-note">
					<?php esc_html_e( 'e.g. : ', 'mmt-eo-exim' ); ?>
					<i>
					https://www.eventbrite.com/e/mokchya-live-concert-tickets-<b>84093713561</b>
					</i>
				</span>
			</div>
			<div class="mmt-eo-ei-block">
				<span class="mmt-eo-ei-note">
					<?php esc_html_e( 'Event ID is the end number of the URL.', 'mmt-eo-ei' ); ?>
				</span>
			</div>
			<div class="mmt-eo-ei-block">
				<a href="#" class="mmt_eo_exim_btn_secondary eb_fetch_by" data-by="event_id">
					<?php esc_html_e( 'Fetch Event(s)', 'mmt-eo-exim' ); ?>
				</a>
			</div>
		</div>
		<div class="mmt-eo-exim-option-block show" id="by_organizer_id">
			<div class="mmt-eo-ei-block">
				<label class="regular inline"><?php esc_html_e( 'Organization ID', 'mmt-eo-exim' ); ?></label>
				<input type="text" class="inline" name="eb_imports_by_organizer_id_oid"/>
			</div>
			<div class="mmt-eo-ei-block">
				<span class="mmt-eo-ei-note">
					<?php esc_html_e( 'Please select start date range.', 'mmt-eo-ei' ); ?>
				</span>
			</div>
			<div class="mmt-eo-ei-block">
				<label class="regular inline"><?php esc_html_e( 'Start Range', 'mmt-eo-exim' ); ?></label>
				<input type="text" class="inline exim-admin-datepicker" name="eb_imports_by_organizer_sd"/>
			</div>
			<div class="mmt-eo-ei-block">
				<label class="regular inline"><?php esc_html_e( 'End Range', 'mmt-eo-exim' ); ?></label>
				<input type="text" class="inline exim-admin-datepicker" name="eb_imports_by_organizer_ed"/>
			</div>
			<div class="mmt-eo-ei-block">
				<a href="#" class="mmt_eo_exim_btn_secondary eb_fetch_by" data-by="organizer_id">
					<?php esc_html_e( 'Fetch Event(s)', 'mmt-eo-exim' ); ?>
				</a>
			</div>
		</div>
		<div class="mmt-eo-exim-option-block show" id="by_venue_id">
			<div class="mmt-eo-ei-block">
				<label class="regular inline"><?php esc_html_e( 'Venue ID', 'mmt-eo-exim' ); ?></label>
				<input type="text" class="inline" name="eb_imports_by_venue_id_vid"/>
			</div>
			<div class="mmt-eo-ei-block">
				<span class="mmt-eo-ei-note">
					<?php esc_html_e( 'Please select start date range.', 'mmt-eo-ei' ); ?>
				</span>
			</div>
			<div class="mmt-eo-ei-block">
				<label class="regular inline"><?php esc_html_e( 'Start Range', 'mmt-eo-exim' ); ?></label>
				<input type="text" class="inline exim-admin-datepicker" name="eb_imports_by_venue_sd"/>
			</div>
			<div class="mmt-eo-ei-block">
				<label class="regular inline"><?php esc_html_e( 'End Range', 'mmt-eo-exim' ); ?></label>
				<input type="text" class="inline exim-admin-datepicker" name="eb_imports_by_venue_ed"/>
			</div>
			<div class="mmt-eo-ei-block">
				<a href="#" class="mmt_eo_exim_btn_secondary eb_fetch_by" data-by="venue_id">
					<?php esc_html_e( 'Fetch Event(s)', 'mmt-eo-exim' ); ?>
				</a>
			</div>
		</div>
		<div class="mmt-eo-exim-back-to-list-block">
			<span class="exim-float-right mmt_eo_exim_btn_primary  eb_back_to_fetch_list">
				<?php esc_html_e( 'Back to event(s) list', 'mmt-eo-ei' ); ?><i class="fa fa-angle-right"></i>
			</span>
		</div>
	</div>
	<div class="mmt-eo-exim-admin-content-main eb_imports_report_block">
		<div class="eb_imports_msg_block"></div>
		<input name="eb_generated_events" id="eb_generated_events" type="hidden" value=""/>
		<div class="eb_imports_table">
			<table>
				<thead>
					<tr>
						<th>
						</th>
						<th>
							<?php esc_html_e( 'Event Name', 'mmt-eo-exim' ); ?>
						</th>
						<th>
							<?php esc_html_e( 'Start Date', 'mmt-eo-exim' ); ?>
						</th>
						<th>
							<?php esc_html_e( 'End Date', 'mmt-eo-exim' ); ?>
						</th>
						<th>
							<?php esc_html_e( 'Summary', 'mmt-eo-exim' ); ?>
						</th>
						<th>
							<?php esc_html_e( 'Status', 'mmt-eo-exim' ); ?>
						</th>
					</tr>
				</thead>
				<tbody>

				</tbody>
			</table>
			<em class="hr_line_blank"></em>
			<span class="mmt_eo_exim_btn_secondary mmt-eo-exim-cb-ebrite-imports">
				<?php esc_html_e( 'Import Event(s)', 'mmt-eo-exim' ); ?>
			</span>
		</div>
		<div class="exim-more-fetch-box">
			<span class="mmt_eo_exim_btn_primary mmt-eo-exim-cb-ebrite-fetch-more">
				<?php esc_html_e( 'Fetch More Event(s)', 'mmt-eo-exim' ); ?>
			</span>
		</div>
	</div>
</div>
