<?php
/**
 * Plugin Name: MMT - EventON - ExIm
 * Plugin URI: http://www.momothemes.com/
 * Description: Addons for EventON to export / import events to / from Eventbrite.
 * Text Domain: mmt-eo-exim
 * Domain Path: /languages
 * Author: MoMo Themes
 * Version: 1.0
 * Author URI: http://www.momothemes.com/
 * Requires at least: 5.0.0
 * Tested up to: 5.7.2
 */
class MMT_Eventon_ExIm {
	/**
	 * Plugin Version
	 *
	 * @var string
	 */
	public $version = '0.1';
	/**
	 * Plugin Name
	 *
	 * @var string
	 */
	public $name = 'MMT Eventon ExIm';
	/**
	 * Plugin ID
	 *
	 * @var string
	 */
	public $id = 'EXIM';
	/**
	 * Plugin Slug
	 *
	 * @var string
	 */
	public $slug = 'mmt-eventon-exim';
	/**
	 * Plugin URL
	 *
	 * @var string
	 */
	public $plugin_url;
	/**
	 * Plugin Slug
	 *
	 * @var string
	 */
	public $plugin_slug = 'mmt-eo-exim';
	/**
	 * Eventon Version
	 *
	 * @var string
	 */
	public $eventon_version = '3.1.5';
	/**
	 * Constructor
	 */
	public function __construct() {
		add_action( 'plugins_loaded', array( $this, 'plugin_init' ) );
	}
	/**
	 * Plugin Init
	 * Check if EventON main plugin exist
	 */
	public function plugin_init() {
		$this->plugin_url = plugin_dir_url( __FILE__ );
		if ( ! isset( $GLOBALS['eventon'] ) ) {
			add_action( 'admin_notices', array( $this, 'mmt_eo_exim_admin_notice' ) );
			return false;
		}
		add_action( 'admin_menu', array( $this, 'mmt_eo_exim_set_menu_in_eventon' ) );
		add_action( 'init', array( $this, 'mmt_eo_exim_init' ), 0 );
	}

	/**
	 * Eventon missing
	 */
	public function mmt_eo_exim_admin_notice() {
		?>
		<div class="message error">
			<p>
			<?php
				/* translators: %s: plugin name */
				printf( esc_html__( '%s is enabled but not effective! - ' ), esc_html( $this->name ) );
				echo esc_html__( 'You do not have EventON main plugin , which is REQUIRED.', 'mmt-eo-exim' );
			?>
			</p>
		</div>
		<?php
	}
	/**
	 * Initiate Plugin
	 */
	public function mmt_eo_exim_init() {
		include_once 'includes/class-mmt-eo-exim-ss.php';
		include_once 'includes/class-mmt-eo-exim-functions.php';
		include_once 'includes/class-mmt-eo-exim-currency-list.php';

		$this->scripts = new MMT_EO_ExIm_SS();
		$this->fn      = new MMT_EO_ExIm_Functions();

		if ( is_admin() ) {
			include_once 'includes/admin/class-mmt-eo-exim-admin-ajax.php';
			include_once 'includes/admin/class-mmt-eo-exim-export-eventbrite.php';
		}
	}

	/**
	 * Set submenu in Eventon Settings Menu
	 */
	public function mmt_eo_exim_set_menu_in_eventon() {
		add_submenu_page(
			'eventon',
			esc_html__( 'ExIm', 'mmt-eo-exim' ),
			esc_html__( 'ExIm', 'mmt-eo-exim' ),
			'administrator',
			'mmt-eo-exim',
			array( $this, 'mmt_eo_exim_settings_page' )
		);
	}
	/**
	 * Admin Settings Page
	 */
	public function mmt_eo_exim_settings_page() {
		include_once 'includes/admin/admin-settings-page.php';
	}
}
// Initiate this addon within the plugin.
$GLOBALS['mmt_eo_exim'] = new MMT_Eventon_ExIm();
